/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkPhysicalDeviceSampleLocationsPropertiesEXT
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SAMPLELOCATIONSAMPLECOUNTS;
    public static final int MAXSAMPLELOCATIONGRIDSIZE;
    public static final int SAMPLELOCATIONCOORDINATERANGE;
    public static final int SAMPLELOCATIONSUBPIXELBITS;
    public static final int VARIABLESAMPLELOCATIONS;

    VkPhysicalDeviceSampleLocationsPropertiesEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkPhysicalDeviceSampleLocationsPropertiesEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPhysicalDeviceSampleLocationsPropertiesEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceSampleLocationsPropertiesEXT.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceSampleLocationsPropertiesEXT.npNext(this.address());
    }

    @NativeType(value="VkSampleCountFlags")
    public int sampleLocationSampleCounts() {
        return VkPhysicalDeviceSampleLocationsPropertiesEXT.nsampleLocationSampleCounts(this.address());
    }

    public VkExtent2D maxSampleLocationGridSize() {
        return VkPhysicalDeviceSampleLocationsPropertiesEXT.nmaxSampleLocationGridSize(this.address());
    }

    public VkPhysicalDeviceSampleLocationsPropertiesEXT maxSampleLocationGridSize(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.maxSampleLocationGridSize());
        return this;
    }

    @NativeType(value="float[2]")
    public FloatBuffer sampleLocationCoordinateRange() {
        return VkPhysicalDeviceSampleLocationsPropertiesEXT.nsampleLocationCoordinateRange(this.address());
    }

    public float sampleLocationCoordinateRange(int index) {
        return VkPhysicalDeviceSampleLocationsPropertiesEXT.nsampleLocationCoordinateRange(this.address(), index);
    }

    @NativeType(value="uint32_t")
    public int sampleLocationSubPixelBits() {
        return VkPhysicalDeviceSampleLocationsPropertiesEXT.nsampleLocationSubPixelBits(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean variableSampleLocations() {
        return VkPhysicalDeviceSampleLocationsPropertiesEXT.nvariableSampleLocations(this.address()) != 0;
    }

    public VkPhysicalDeviceSampleLocationsPropertiesEXT sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceSampleLocationsPropertiesEXT.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceSampleLocationsPropertiesEXT pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceSampleLocationsPropertiesEXT.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceSampleLocationsPropertiesEXT set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceSampleLocationsPropertiesEXT set(VkPhysicalDeviceSampleLocationsPropertiesEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceSampleLocationsPropertiesEXT create(long address) {
        return new VkPhysicalDeviceSampleLocationsPropertiesEXT(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceSampleLocationsPropertiesEXT createSafe(long address) {
        return address == 0L ? null : VkPhysicalDeviceSampleLocationsPropertiesEXT.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPhysicalDeviceSampleLocationsPropertiesEXT.create(address, capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nsampleLocationSampleCounts(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLELOCATIONSAMPLECOUNTS);
    }

    public static VkExtent2D nmaxSampleLocationGridSize(long struct) {
        return VkExtent2D.create(struct + (long)MAXSAMPLELOCATIONGRIDSIZE);
    }

    public static FloatBuffer nsampleLocationCoordinateRange(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)SAMPLELOCATIONCOORDINATERANGE, 2);
    }

    public static float nsampleLocationCoordinateRange(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)SAMPLELOCATIONCOORDINATERANGE + Checks.check(index, 2) * 4L);
    }

    public static int nsampleLocationSubPixelBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLELOCATIONSUBPIXELBITS);
    }

    public static int nvariableSampleLocations(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VARIABLESAMPLELOCATIONS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceSampleLocationsPropertiesEXT.__struct(VkPhysicalDeviceSampleLocationsPropertiesEXT.__member(4), VkPhysicalDeviceSampleLocationsPropertiesEXT.__member(POINTER_SIZE), VkPhysicalDeviceSampleLocationsPropertiesEXT.__member(4), VkPhysicalDeviceSampleLocationsPropertiesEXT.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkPhysicalDeviceSampleLocationsPropertiesEXT.__array(4, 2), VkPhysicalDeviceSampleLocationsPropertiesEXT.__member(4), VkPhysicalDeviceSampleLocationsPropertiesEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SAMPLELOCATIONSAMPLECOUNTS = layout.offsetof(2);
        MAXSAMPLELOCATIONGRIDSIZE = layout.offsetof(3);
        SAMPLELOCATIONCOORDINATERANGE = layout.offsetof(4);
        SAMPLELOCATIONSUBPIXELBITS = layout.offsetof(5);
        VARIABLESAMPLELOCATIONS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceSampleLocationsPropertiesEXT, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPhysicalDeviceSampleLocationsPropertiesEXT newInstance(long address) {
            return new VkPhysicalDeviceSampleLocationsPropertiesEXT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceSampleLocationsPropertiesEXT.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceSampleLocationsPropertiesEXT.npNext(this.address());
        }

        @NativeType(value="VkSampleCountFlags")
        public int sampleLocationSampleCounts() {
            return VkPhysicalDeviceSampleLocationsPropertiesEXT.nsampleLocationSampleCounts(this.address());
        }

        public VkExtent2D maxSampleLocationGridSize() {
            return VkPhysicalDeviceSampleLocationsPropertiesEXT.nmaxSampleLocationGridSize(this.address());
        }

        public Buffer maxSampleLocationGridSize(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.maxSampleLocationGridSize());
            return this;
        }

        @NativeType(value="float[2]")
        public FloatBuffer sampleLocationCoordinateRange() {
            return VkPhysicalDeviceSampleLocationsPropertiesEXT.nsampleLocationCoordinateRange(this.address());
        }

        public float sampleLocationCoordinateRange(int index) {
            return VkPhysicalDeviceSampleLocationsPropertiesEXT.nsampleLocationCoordinateRange(this.address(), index);
        }

        @NativeType(value="uint32_t")
        public int sampleLocationSubPixelBits() {
            return VkPhysicalDeviceSampleLocationsPropertiesEXT.nsampleLocationSubPixelBits(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean variableSampleLocations() {
            return VkPhysicalDeviceSampleLocationsPropertiesEXT.nvariableSampleLocations(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceSampleLocationsPropertiesEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceSampleLocationsPropertiesEXT.npNext(this.address(), value);
            return this;
        }
    }
}

