/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceProtectedMemoryFeatures
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PROTECTEDMEMORY;

    VkPhysicalDeviceProtectedMemoryFeatures(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkPhysicalDeviceProtectedMemoryFeatures(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPhysicalDeviceProtectedMemoryFeatures.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceProtectedMemoryFeatures.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceProtectedMemoryFeatures.npNext(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean protectedMemory() {
        return VkPhysicalDeviceProtectedMemoryFeatures.nprotectedMemory(this.address()) != 0;
    }

    public VkPhysicalDeviceProtectedMemoryFeatures sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceProtectedMemoryFeatures.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryFeatures pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceProtectedMemoryFeatures.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryFeatures protectedMemory(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceProtectedMemoryFeatures.nprotectedMemory(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryFeatures set(int sType, long pNext, boolean protectedMemory) {
        this.sType(sType);
        this.pNext(pNext);
        this.protectedMemory(protectedMemory);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryFeatures set(VkPhysicalDeviceProtectedMemoryFeatures src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures malloc() {
        return VkPhysicalDeviceProtectedMemoryFeatures.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures calloc() {
        return VkPhysicalDeviceProtectedMemoryFeatures.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures create() {
        return new VkPhysicalDeviceProtectedMemoryFeatures(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures create(long address) {
        return new VkPhysicalDeviceProtectedMemoryFeatures(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceProtectedMemoryFeatures createSafe(long address) {
        return address == 0L ? null : VkPhysicalDeviceProtectedMemoryFeatures.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkPhysicalDeviceProtectedMemoryFeatures.create(VkPhysicalDeviceProtectedMemoryFeatures.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPhysicalDeviceProtectedMemoryFeatures.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkPhysicalDeviceProtectedMemoryFeatures.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPhysicalDeviceProtectedMemoryFeatures.create(address, capacity);
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures mallocStack() {
        return VkPhysicalDeviceProtectedMemoryFeatures.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures callocStack() {
        return VkPhysicalDeviceProtectedMemoryFeatures.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryFeatures.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures callocStack(MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryFeatures.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceProtectedMemoryFeatures.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceProtectedMemoryFeatures.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryFeatures.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryFeatures.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nprotectedMemory(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PROTECTEDMEMORY);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nprotectedMemory(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PROTECTEDMEMORY, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceProtectedMemoryFeatures.__struct(VkPhysicalDeviceProtectedMemoryFeatures.__member(4), VkPhysicalDeviceProtectedMemoryFeatures.__member(POINTER_SIZE), VkPhysicalDeviceProtectedMemoryFeatures.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PROTECTEDMEMORY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceProtectedMemoryFeatures, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPhysicalDeviceProtectedMemoryFeatures newInstance(long address) {
            return new VkPhysicalDeviceProtectedMemoryFeatures(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceProtectedMemoryFeatures.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceProtectedMemoryFeatures.npNext(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean protectedMemory() {
            return VkPhysicalDeviceProtectedMemoryFeatures.nprotectedMemory(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceProtectedMemoryFeatures.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceProtectedMemoryFeatures.npNext(this.address(), value);
            return this;
        }

        public Buffer protectedMemory(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceProtectedMemoryFeatures.nprotectedMemory(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

