/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkPhysicalDeviceMemoryProperties2;

public class VkPhysicalDeviceMemoryProperties2KHR
extends VkPhysicalDeviceMemoryProperties2 {
    VkPhysicalDeviceMemoryProperties2KHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkPhysicalDeviceMemoryProperties2KHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPhysicalDeviceMemoryProperties2KHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkPhysicalDeviceMemoryProperties2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceMemoryProperties2KHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkPhysicalDeviceMemoryProperties2KHR pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceMemoryProperties2KHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkPhysicalDeviceMemoryProperties2KHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceMemoryProperties2KHR set(VkPhysicalDeviceMemoryProperties2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceMemoryProperties2KHR malloc() {
        return VkPhysicalDeviceMemoryProperties2KHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPhysicalDeviceMemoryProperties2KHR calloc() {
        return VkPhysicalDeviceMemoryProperties2KHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPhysicalDeviceMemoryProperties2KHR create() {
        return new VkPhysicalDeviceMemoryProperties2KHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPhysicalDeviceMemoryProperties2KHR create(long address) {
        return new VkPhysicalDeviceMemoryProperties2KHR(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceMemoryProperties2KHR createSafe(long address) {
        return address == 0L ? null : VkPhysicalDeviceMemoryProperties2KHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkPhysicalDeviceMemoryProperties2KHR.create(VkPhysicalDeviceMemoryProperties2KHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPhysicalDeviceMemoryProperties2KHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkPhysicalDeviceMemoryProperties2KHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPhysicalDeviceMemoryProperties2KHR.create(address, capacity);
    }

    public static VkPhysicalDeviceMemoryProperties2KHR mallocStack() {
        return VkPhysicalDeviceMemoryProperties2KHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceMemoryProperties2KHR callocStack() {
        return VkPhysicalDeviceMemoryProperties2KHR.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceMemoryProperties2KHR mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties2KHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceMemoryProperties2KHR callocStack(MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties2KHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceMemoryProperties2KHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceMemoryProperties2KHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties2KHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties2KHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkPhysicalDeviceMemoryProperties2.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPhysicalDeviceMemoryProperties2KHR newInstance(long address) {
            return new VkPhysicalDeviceMemoryProperties2KHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceMemoryProperties2KHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceMemoryProperties2KHR.npNext(this.address(), value);
            return this;
        }
    }
}

