/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceGroupProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PHYSICALDEVICECOUNT;
    public static final int PHYSICALDEVICES;
    public static final int SUBSETALLOCATION;

    VkPhysicalDeviceGroupProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkPhysicalDeviceGroupProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPhysicalDeviceGroupProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceGroupProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceGroupProperties.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int physicalDeviceCount() {
        return VkPhysicalDeviceGroupProperties.nphysicalDeviceCount(this.address());
    }

    @NativeType(value="VkPhysicalDevice[VK_MAX_DEVICE_GROUP_SIZE]")
    public PointerBuffer physicalDevices() {
        return VkPhysicalDeviceGroupProperties.nphysicalDevices(this.address());
    }

    @NativeType(value="VkPhysicalDevice")
    public long physicalDevices(int index) {
        return VkPhysicalDeviceGroupProperties.nphysicalDevices(this.address(), index);
    }

    @NativeType(value="VkBool32")
    public boolean subsetAllocation() {
        return VkPhysicalDeviceGroupProperties.nsubsetAllocation(this.address()) != 0;
    }

    public VkPhysicalDeviceGroupProperties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceGroupProperties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceGroupProperties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceGroupProperties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceGroupProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceGroupProperties set(VkPhysicalDeviceGroupProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceGroupProperties malloc() {
        return VkPhysicalDeviceGroupProperties.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPhysicalDeviceGroupProperties calloc() {
        return VkPhysicalDeviceGroupProperties.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPhysicalDeviceGroupProperties create() {
        return new VkPhysicalDeviceGroupProperties(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPhysicalDeviceGroupProperties create(long address) {
        return new VkPhysicalDeviceGroupProperties(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceGroupProperties createSafe(long address) {
        return address == 0L ? null : VkPhysicalDeviceGroupProperties.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkPhysicalDeviceGroupProperties.create(VkPhysicalDeviceGroupProperties.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPhysicalDeviceGroupProperties.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkPhysicalDeviceGroupProperties.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPhysicalDeviceGroupProperties.create(address, capacity);
    }

    public static VkPhysicalDeviceGroupProperties mallocStack() {
        return VkPhysicalDeviceGroupProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceGroupProperties callocStack() {
        return VkPhysicalDeviceGroupProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceGroupProperties mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceGroupProperties.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceGroupProperties callocStack(MemoryStack stack) {
        return VkPhysicalDeviceGroupProperties.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceGroupProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceGroupProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceGroupProperties.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceGroupProperties.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nphysicalDeviceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PHYSICALDEVICECOUNT);
    }

    public static PointerBuffer nphysicalDevices(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)PHYSICALDEVICES, 32);
    }

    public static long nphysicalDevices(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)PHYSICALDEVICES + Checks.check(index, 32) * (long)POINTER_SIZE);
    }

    public static int nsubsetAllocation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBSETALLOCATION);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceGroupProperties.__struct(VkPhysicalDeviceGroupProperties.__member(4), VkPhysicalDeviceGroupProperties.__member(POINTER_SIZE), VkPhysicalDeviceGroupProperties.__member(4), VkPhysicalDeviceGroupProperties.__array(POINTER_SIZE, 32), VkPhysicalDeviceGroupProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PHYSICALDEVICECOUNT = layout.offsetof(2);
        PHYSICALDEVICES = layout.offsetof(3);
        SUBSETALLOCATION = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceGroupProperties, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPhysicalDeviceGroupProperties newInstance(long address) {
            return new VkPhysicalDeviceGroupProperties(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceGroupProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceGroupProperties.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int physicalDeviceCount() {
            return VkPhysicalDeviceGroupProperties.nphysicalDeviceCount(this.address());
        }

        @NativeType(value="VkPhysicalDevice[VK_MAX_DEVICE_GROUP_SIZE]")
        public PointerBuffer physicalDevices() {
            return VkPhysicalDeviceGroupProperties.nphysicalDevices(this.address());
        }

        @NativeType(value="VkPhysicalDevice")
        public long physicalDevices(int index) {
            return VkPhysicalDeviceGroupProperties.nphysicalDevices(this.address(), index);
        }

        @NativeType(value="VkBool32")
        public boolean subsetAllocation() {
            return VkPhysicalDeviceGroupProperties.nsubsetAllocation(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceGroupProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceGroupProperties.npNext(this.address(), value);
            return this;
        }
    }
}

