/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceExternalBufferInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int USAGE;
    public static final int HANDLETYPE;

    VkPhysicalDeviceExternalBufferInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkPhysicalDeviceExternalBufferInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPhysicalDeviceExternalBufferInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceExternalBufferInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPhysicalDeviceExternalBufferInfo.npNext(this.address());
    }

    @NativeType(value="VkBufferCreateFlags")
    public int flags() {
        return VkPhysicalDeviceExternalBufferInfo.nflags(this.address());
    }

    @NativeType(value="VkBufferUsageFlags")
    public int usage() {
        return VkPhysicalDeviceExternalBufferInfo.nusage(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
    public int handleType() {
        return VkPhysicalDeviceExternalBufferInfo.nhandleType(this.address());
    }

    public VkPhysicalDeviceExternalBufferInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceExternalBufferInfo.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceExternalBufferInfo pNext(@NativeType(value="void const *") long value) {
        VkPhysicalDeviceExternalBufferInfo.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceExternalBufferInfo flags(@NativeType(value="VkBufferCreateFlags") int value) {
        VkPhysicalDeviceExternalBufferInfo.nflags(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceExternalBufferInfo usage(@NativeType(value="VkBufferUsageFlags") int value) {
        VkPhysicalDeviceExternalBufferInfo.nusage(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceExternalBufferInfo handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
        VkPhysicalDeviceExternalBufferInfo.nhandleType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceExternalBufferInfo set(int sType, long pNext, int flags, int usage, int handleType) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.usage(usage);
        this.handleType(handleType);
        return this;
    }

    public VkPhysicalDeviceExternalBufferInfo set(VkPhysicalDeviceExternalBufferInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceExternalBufferInfo malloc() {
        return VkPhysicalDeviceExternalBufferInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPhysicalDeviceExternalBufferInfo calloc() {
        return VkPhysicalDeviceExternalBufferInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPhysicalDeviceExternalBufferInfo create() {
        return new VkPhysicalDeviceExternalBufferInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPhysicalDeviceExternalBufferInfo create(long address) {
        return new VkPhysicalDeviceExternalBufferInfo(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceExternalBufferInfo createSafe(long address) {
        return address == 0L ? null : VkPhysicalDeviceExternalBufferInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkPhysicalDeviceExternalBufferInfo.create(VkPhysicalDeviceExternalBufferInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPhysicalDeviceExternalBufferInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkPhysicalDeviceExternalBufferInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPhysicalDeviceExternalBufferInfo.create(address, capacity);
    }

    public static VkPhysicalDeviceExternalBufferInfo mallocStack() {
        return VkPhysicalDeviceExternalBufferInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceExternalBufferInfo callocStack() {
        return VkPhysicalDeviceExternalBufferInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceExternalBufferInfo mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceExternalBufferInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceExternalBufferInfo callocStack(MemoryStack stack) {
        return VkPhysicalDeviceExternalBufferInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceExternalBufferInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceExternalBufferInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceExternalBufferInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceExternalBufferInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nusage(long struct) {
        return MemoryUtil.memGetInt(struct + (long)USAGE);
    }

    public static int nhandleType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nusage(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)USAGE, value);
    }

    public static void nhandleType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPE, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceExternalBufferInfo.__struct(VkPhysicalDeviceExternalBufferInfo.__member(4), VkPhysicalDeviceExternalBufferInfo.__member(POINTER_SIZE), VkPhysicalDeviceExternalBufferInfo.__member(4), VkPhysicalDeviceExternalBufferInfo.__member(4), VkPhysicalDeviceExternalBufferInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        USAGE = layout.offsetof(3);
        HANDLETYPE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceExternalBufferInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPhysicalDeviceExternalBufferInfo newInstance(long address) {
            return new VkPhysicalDeviceExternalBufferInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceExternalBufferInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPhysicalDeviceExternalBufferInfo.npNext(this.address());
        }

        @NativeType(value="VkBufferCreateFlags")
        public int flags() {
            return VkPhysicalDeviceExternalBufferInfo.nflags(this.address());
        }

        @NativeType(value="VkBufferUsageFlags")
        public int usage() {
            return VkPhysicalDeviceExternalBufferInfo.nusage(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
        public int handleType() {
            return VkPhysicalDeviceExternalBufferInfo.nhandleType(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceExternalBufferInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPhysicalDeviceExternalBufferInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkBufferCreateFlags") int value) {
            VkPhysicalDeviceExternalBufferInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer usage(@NativeType(value="VkBufferUsageFlags") int value) {
            VkPhysicalDeviceExternalBufferInfo.nusage(this.address(), value);
            return this;
        }

        public Buffer handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
            VkPhysicalDeviceExternalBufferInfo.nhandleType(this.address(), value);
            return this;
        }
    }
}

