/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkOffset2D
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    VkOffset2D(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkOffset2D(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkOffset2D.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int x() {
        return VkOffset2D.nx(this.address());
    }

    @NativeType(value="int32_t")
    public int y() {
        return VkOffset2D.ny(this.address());
    }

    public VkOffset2D x(@NativeType(value="int32_t") int value) {
        VkOffset2D.nx(this.address(), value);
        return this;
    }

    public VkOffset2D y(@NativeType(value="int32_t") int value) {
        VkOffset2D.ny(this.address(), value);
        return this;
    }

    public VkOffset2D set(int x, int y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public VkOffset2D set(VkOffset2D src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkOffset2D malloc() {
        return VkOffset2D.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkOffset2D calloc() {
        return VkOffset2D.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkOffset2D create() {
        return new VkOffset2D(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkOffset2D create(long address) {
        return new VkOffset2D(address, null);
    }

    @Nullable
    public static VkOffset2D createSafe(long address) {
        return address == 0L ? null : VkOffset2D.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkOffset2D.create(VkOffset2D.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkOffset2D.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkOffset2D.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkOffset2D.create(address, capacity);
    }

    public static VkOffset2D mallocStack() {
        return VkOffset2D.mallocStack(MemoryStack.stackGet());
    }

    public static VkOffset2D callocStack() {
        return VkOffset2D.callocStack(MemoryStack.stackGet());
    }

    public static VkOffset2D mallocStack(MemoryStack stack) {
        return VkOffset2D.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkOffset2D callocStack(MemoryStack stack) {
        return VkOffset2D.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkOffset2D.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkOffset2D.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkOffset2D.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkOffset2D.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = VkOffset2D.__struct(VkOffset2D.__member(4), VkOffset2D.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkOffset2D, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkOffset2D newInstance(long address) {
            return new VkOffset2D(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="int32_t")
        public int x() {
            return VkOffset2D.nx(this.address());
        }

        @NativeType(value="int32_t")
        public int y() {
            return VkOffset2D.ny(this.address());
        }

        public Buffer x(@NativeType(value="int32_t") int value) {
            VkOffset2D.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="int32_t") int value) {
            VkOffset2D.ny(this.address(), value);
            return this;
        }
    }
}

