/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryFdPropertiesKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORYTYPEBITS;

    VkMemoryFdPropertiesKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryFdPropertiesKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryFdPropertiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryFdPropertiesKHR.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkMemoryFdPropertiesKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryTypeBits() {
        return VkMemoryFdPropertiesKHR.nmemoryTypeBits(this.address());
    }

    public VkMemoryFdPropertiesKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryFdPropertiesKHR.nsType(this.address(), value);
        return this;
    }

    public VkMemoryFdPropertiesKHR pNext(@NativeType(value="void *") long value) {
        VkMemoryFdPropertiesKHR.npNext(this.address(), value);
        return this;
    }

    public VkMemoryFdPropertiesKHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkMemoryFdPropertiesKHR set(VkMemoryFdPropertiesKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryFdPropertiesKHR malloc() {
        return VkMemoryFdPropertiesKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryFdPropertiesKHR calloc() {
        return VkMemoryFdPropertiesKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryFdPropertiesKHR create() {
        return new VkMemoryFdPropertiesKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMemoryFdPropertiesKHR create(long address) {
        return new VkMemoryFdPropertiesKHR(address, null);
    }

    @Nullable
    public static VkMemoryFdPropertiesKHR createSafe(long address) {
        return address == 0L ? null : VkMemoryFdPropertiesKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryFdPropertiesKHR.create(VkMemoryFdPropertiesKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryFdPropertiesKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkMemoryFdPropertiesKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryFdPropertiesKHR.create(address, capacity);
    }

    public static VkMemoryFdPropertiesKHR mallocStack() {
        return VkMemoryFdPropertiesKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryFdPropertiesKHR callocStack() {
        return VkMemoryFdPropertiesKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryFdPropertiesKHR mallocStack(MemoryStack stack) {
        return VkMemoryFdPropertiesKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryFdPropertiesKHR callocStack(MemoryStack stack) {
        return VkMemoryFdPropertiesKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryFdPropertiesKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryFdPropertiesKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryFdPropertiesKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryFdPropertiesKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nmemoryTypeBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYTYPEBITS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkMemoryFdPropertiesKHR.__struct(VkMemoryFdPropertiesKHR.__member(4), VkMemoryFdPropertiesKHR.__member(POINTER_SIZE), VkMemoryFdPropertiesKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORYTYPEBITS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryFdPropertiesKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryFdPropertiesKHR newInstance(long address) {
            return new VkMemoryFdPropertiesKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryFdPropertiesKHR.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkMemoryFdPropertiesKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryTypeBits() {
            return VkMemoryFdPropertiesKHR.nmemoryTypeBits(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryFdPropertiesKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkMemoryFdPropertiesKHR.npNext(this.address(), value);
            return this;
        }
    }
}

