/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryDedicatedRequirements
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PREFERSDEDICATEDALLOCATION;
    public static final int REQUIRESDEDICATEDALLOCATION;

    VkMemoryDedicatedRequirements(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryDedicatedRequirements(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryDedicatedRequirements.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryDedicatedRequirements.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkMemoryDedicatedRequirements.npNext(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean prefersDedicatedAllocation() {
        return VkMemoryDedicatedRequirements.nprefersDedicatedAllocation(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean requiresDedicatedAllocation() {
        return VkMemoryDedicatedRequirements.nrequiresDedicatedAllocation(this.address()) != 0;
    }

    public VkMemoryDedicatedRequirements sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryDedicatedRequirements.nsType(this.address(), value);
        return this;
    }

    public VkMemoryDedicatedRequirements pNext(@NativeType(value="void *") long value) {
        VkMemoryDedicatedRequirements.npNext(this.address(), value);
        return this;
    }

    public VkMemoryDedicatedRequirements set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkMemoryDedicatedRequirements set(VkMemoryDedicatedRequirements src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryDedicatedRequirements create(long address) {
        return new VkMemoryDedicatedRequirements(address, null);
    }

    @Nullable
    public static VkMemoryDedicatedRequirements createSafe(long address) {
        return address == 0L ? null : VkMemoryDedicatedRequirements.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryDedicatedRequirements.create(address, capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nprefersDedicatedAllocation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PREFERSDEDICATEDALLOCATION);
    }

    public static int nrequiresDedicatedAllocation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REQUIRESDEDICATEDALLOCATION);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkMemoryDedicatedRequirements.__struct(VkMemoryDedicatedRequirements.__member(4), VkMemoryDedicatedRequirements.__member(POINTER_SIZE), VkMemoryDedicatedRequirements.__member(4), VkMemoryDedicatedRequirements.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PREFERSDEDICATEDALLOCATION = layout.offsetof(2);
        REQUIRESDEDICATEDALLOCATION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryDedicatedRequirements, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryDedicatedRequirements newInstance(long address) {
            return new VkMemoryDedicatedRequirements(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryDedicatedRequirements.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkMemoryDedicatedRequirements.npNext(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean prefersDedicatedAllocation() {
            return VkMemoryDedicatedRequirements.nprefersDedicatedAllocation(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean requiresDedicatedAllocation() {
            return VkMemoryDedicatedRequirements.nrequiresDedicatedAllocation(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryDedicatedRequirements.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkMemoryDedicatedRequirements.npNext(this.address(), value);
            return this;
        }
    }
}

