/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.DispatchableHandleInstance;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkApplicationInfo;
import org.lwjgl.vulkan.VkExtensionProperties;
import org.lwjgl.vulkan.VkInstanceCreateInfo;

public class VkInstance
extends DispatchableHandleInstance {
    public VkInstance(long handle, VkInstanceCreateInfo ci) {
        super(handle, VkInstance.getInstanceCapabilities(handle, ci));
    }

    private static VKCapabilitiesInstance getInstanceCapabilities(long handle, VkInstanceCreateInfo ci) {
        VkApplicationInfo appInfo = ci.pApplicationInfo();
        int apiVersion = appInfo != null ? appInfo.apiVersion() : VK.getInstanceVersionSupported();
        return new VKCapabilitiesInstance(functionName -> {
            long address = JNI.callPPP(VK.getGlobalCommands().vkGetInstanceProcAddr, handle, MemoryUtil.memAddress(functionName));
            if (address == 0L && Checks.DEBUG_FUNCTIONS) {
                APIUtil.apiLog("Failed to locate address for VK instance function " + MemoryUtil.memASCII(functionName));
            }
            return address;
        }, apiVersion, VK.getEnabledExtensionSet(apiVersion, ci.ppEnabledExtensionNames()), VkInstance.getAvailableDeviceExtensions(handle));
    }

    private static Set<String> getAvailableDeviceExtensions(long instance) {
        HashSet<String> extensions = new HashSet<String>();
        try (MemoryStack frame0 = MemoryStack.stackPush();){
            int err;
            IntBuffer ip = frame0.callocInt(1);
            long GetInstanceProcAddr = VK.getGlobalCommands().vkGetInstanceProcAddr;
            long EnumeratePhysicalDevices = JNI.callPPP(GetInstanceProcAddr, instance, MemoryUtil.memAddress(frame0.ASCII("vkEnumeratePhysicalDevices")));
            long EnumerateDeviceExtensionProperties = JNI.callPPP(GetInstanceProcAddr, instance, MemoryUtil.memAddress(frame0.ASCII("vkEnumerateDeviceExtensionProperties")));
            if (EnumeratePhysicalDevices != 0L && EnumerateDeviceExtensionProperties != 0L && (err = JNI.callPPPI(EnumeratePhysicalDevices, instance, MemoryUtil.memAddress(ip), 0L)) == 0 && ip.get(0) != 0) {
                PointerBuffer physicalDevices = frame0.mallocPointer(ip.get(0));
                err = JNI.callPPPI(EnumeratePhysicalDevices, instance, MemoryUtil.memAddress(ip), MemoryUtil.memAddress(physicalDevices));
                if (err == 0) {
                    for (int i = 0; i < physicalDevices.remaining(); ++i) {
                        err = JNI.callPPPPI(EnumerateDeviceExtensionProperties, physicalDevices.get(i), 0L, MemoryUtil.memAddress(ip), 0L);
                        if (err != 0 || ip.get(0) == 0) continue;
                        try (MemoryStack frame1 = frame0.push();){
                            VkExtensionProperties.Buffer deviceExtensions = VkExtensionProperties.mallocStack(ip.get(0), frame1);
                            err = JNI.callPPPPI(EnumerateDeviceExtensionProperties, physicalDevices.get(i), 0L, MemoryUtil.memAddress(ip), deviceExtensions.address());
                            if (err != 0) continue;
                            for (int j = 0; j < deviceExtensions.remaining(); ++j) {
                                extensions.add(((VkExtensionProperties)deviceExtensions.get(j)).extensionNameString());
                            }
                            continue;
                        }
                    }
                }
            }
        }
        return extensions;
    }
}

