/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImportMemoryHostPointerInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPE;
    public static final int PHOSTPOINTER;

    VkImportMemoryHostPointerInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkImportMemoryHostPointerInfoEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImportMemoryHostPointerInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImportMemoryHostPointerInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImportMemoryHostPointerInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
    public int handleType() {
        return VkImportMemoryHostPointerInfoEXT.nhandleType(this.address());
    }

    @NativeType(value="void *")
    public long pHostPointer() {
        return VkImportMemoryHostPointerInfoEXT.npHostPointer(this.address());
    }

    public VkImportMemoryHostPointerInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkImportMemoryHostPointerInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkImportMemoryHostPointerInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkImportMemoryHostPointerInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkImportMemoryHostPointerInfoEXT handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
        VkImportMemoryHostPointerInfoEXT.nhandleType(this.address(), value);
        return this;
    }

    public VkImportMemoryHostPointerInfoEXT pHostPointer(@NativeType(value="void *") long value) {
        VkImportMemoryHostPointerInfoEXT.npHostPointer(this.address(), value);
        return this;
    }

    public VkImportMemoryHostPointerInfoEXT set(int sType, long pNext, int handleType, long pHostPointer) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleType(handleType);
        this.pHostPointer(pHostPointer);
        return this;
    }

    public VkImportMemoryHostPointerInfoEXT set(VkImportMemoryHostPointerInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImportMemoryHostPointerInfoEXT malloc() {
        return VkImportMemoryHostPointerInfoEXT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImportMemoryHostPointerInfoEXT calloc() {
        return VkImportMemoryHostPointerInfoEXT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImportMemoryHostPointerInfoEXT create() {
        return new VkImportMemoryHostPointerInfoEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImportMemoryHostPointerInfoEXT create(long address) {
        return new VkImportMemoryHostPointerInfoEXT(address, null);
    }

    @Nullable
    public static VkImportMemoryHostPointerInfoEXT createSafe(long address) {
        return address == 0L ? null : VkImportMemoryHostPointerInfoEXT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkImportMemoryHostPointerInfoEXT.create(VkImportMemoryHostPointerInfoEXT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImportMemoryHostPointerInfoEXT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkImportMemoryHostPointerInfoEXT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImportMemoryHostPointerInfoEXT.create(address, capacity);
    }

    public static VkImportMemoryHostPointerInfoEXT mallocStack() {
        return VkImportMemoryHostPointerInfoEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkImportMemoryHostPointerInfoEXT callocStack() {
        return VkImportMemoryHostPointerInfoEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkImportMemoryHostPointerInfoEXT mallocStack(MemoryStack stack) {
        return VkImportMemoryHostPointerInfoEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImportMemoryHostPointerInfoEXT callocStack(MemoryStack stack) {
        return VkImportMemoryHostPointerInfoEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImportMemoryHostPointerInfoEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImportMemoryHostPointerInfoEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryHostPointerInfoEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryHostPointerInfoEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPE);
    }

    public static long npHostPointer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PHOSTPOINTER);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPE, value);
    }

    public static void npHostPointer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PHOSTPOINTER, value);
    }

    static {
        Struct.Layout layout = VkImportMemoryHostPointerInfoEXT.__struct(VkImportMemoryHostPointerInfoEXT.__member(4), VkImportMemoryHostPointerInfoEXT.__member(POINTER_SIZE), VkImportMemoryHostPointerInfoEXT.__member(4), VkImportMemoryHostPointerInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPE = layout.offsetof(2);
        PHOSTPOINTER = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkImportMemoryHostPointerInfoEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImportMemoryHostPointerInfoEXT newInstance(long address) {
            return new VkImportMemoryHostPointerInfoEXT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImportMemoryHostPointerInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImportMemoryHostPointerInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
        public int handleType() {
            return VkImportMemoryHostPointerInfoEXT.nhandleType(this.address());
        }

        @NativeType(value="void *")
        public long pHostPointer() {
            return VkImportMemoryHostPointerInfoEXT.npHostPointer(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImportMemoryHostPointerInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImportMemoryHostPointerInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
            VkImportMemoryHostPointerInfoEXT.nhandleType(this.address(), value);
            return this;
        }

        public Buffer pHostPointer(@NativeType(value="void *") long value) {
            VkImportMemoryHostPointerInfoEXT.npHostPointer(this.address(), value);
            return this;
        }
    }
}

