/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImageViewUsageCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int USAGE;

    VkImageViewUsageCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkImageViewUsageCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImageViewUsageCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageViewUsageCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageViewUsageCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkImageUsageFlags")
    public int usage() {
        return VkImageViewUsageCreateInfo.nusage(this.address());
    }

    public VkImageViewUsageCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkImageViewUsageCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkImageViewUsageCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkImageViewUsageCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkImageViewUsageCreateInfo usage(@NativeType(value="VkImageUsageFlags") int value) {
        VkImageViewUsageCreateInfo.nusage(this.address(), value);
        return this;
    }

    public VkImageViewUsageCreateInfo set(int sType, long pNext, int usage) {
        this.sType(sType);
        this.pNext(pNext);
        this.usage(usage);
        return this;
    }

    public VkImageViewUsageCreateInfo set(VkImageViewUsageCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageViewUsageCreateInfo malloc() {
        return VkImageViewUsageCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImageViewUsageCreateInfo calloc() {
        return VkImageViewUsageCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImageViewUsageCreateInfo create() {
        return new VkImageViewUsageCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImageViewUsageCreateInfo create(long address) {
        return new VkImageViewUsageCreateInfo(address, null);
    }

    @Nullable
    public static VkImageViewUsageCreateInfo createSafe(long address) {
        return address == 0L ? null : VkImageViewUsageCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkImageViewUsageCreateInfo.create(VkImageViewUsageCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageViewUsageCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkImageViewUsageCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImageViewUsageCreateInfo.create(address, capacity);
    }

    public static VkImageViewUsageCreateInfo mallocStack() {
        return VkImageViewUsageCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageViewUsageCreateInfo callocStack() {
        return VkImageViewUsageCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkImageViewUsageCreateInfo mallocStack(MemoryStack stack) {
        return VkImageViewUsageCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageViewUsageCreateInfo callocStack(MemoryStack stack) {
        return VkImageViewUsageCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageViewUsageCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageViewUsageCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageViewUsageCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageViewUsageCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nusage(long struct) {
        return MemoryUtil.memGetInt(struct + (long)USAGE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nusage(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)USAGE, value);
    }

    static {
        Struct.Layout layout = VkImageViewUsageCreateInfo.__struct(VkImageViewUsageCreateInfo.__member(4), VkImageViewUsageCreateInfo.__member(POINTER_SIZE), VkImageViewUsageCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        USAGE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkImageViewUsageCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImageViewUsageCreateInfo newInstance(long address) {
            return new VkImageViewUsageCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageViewUsageCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageViewUsageCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkImageUsageFlags")
        public int usage() {
            return VkImageViewUsageCreateInfo.nusage(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageViewUsageCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageViewUsageCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer usage(@NativeType(value="VkImageUsageFlags") int value) {
            VkImageViewUsageCreateInfo.nusage(this.address(), value);
            return this;
        }
    }
}

