/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkFenceGetFdInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FENCE;
    public static final int HANDLETYPE;

    VkFenceGetFdInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkFenceGetFdInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkFenceGetFdInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkFenceGetFdInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkFenceGetFdInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkFence")
    public long fence() {
        return VkFenceGetFdInfoKHR.nfence(this.address());
    }

    @NativeType(value="VkExternalFenceHandleTypeFlagBits")
    public int handleType() {
        return VkFenceGetFdInfoKHR.nhandleType(this.address());
    }

    public VkFenceGetFdInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkFenceGetFdInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkFenceGetFdInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkFenceGetFdInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkFenceGetFdInfoKHR fence(@NativeType(value="VkFence") long value) {
        VkFenceGetFdInfoKHR.nfence(this.address(), value);
        return this;
    }

    public VkFenceGetFdInfoKHR handleType(@NativeType(value="VkExternalFenceHandleTypeFlagBits") int value) {
        VkFenceGetFdInfoKHR.nhandleType(this.address(), value);
        return this;
    }

    public VkFenceGetFdInfoKHR set(int sType, long pNext, long fence, int handleType) {
        this.sType(sType);
        this.pNext(pNext);
        this.fence(fence);
        this.handleType(handleType);
        return this;
    }

    public VkFenceGetFdInfoKHR set(VkFenceGetFdInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkFenceGetFdInfoKHR malloc() {
        return VkFenceGetFdInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkFenceGetFdInfoKHR calloc() {
        return VkFenceGetFdInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkFenceGetFdInfoKHR create() {
        return new VkFenceGetFdInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkFenceGetFdInfoKHR create(long address) {
        return new VkFenceGetFdInfoKHR(address, null);
    }

    @Nullable
    public static VkFenceGetFdInfoKHR createSafe(long address) {
        return address == 0L ? null : VkFenceGetFdInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkFenceGetFdInfoKHR.create(VkFenceGetFdInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkFenceGetFdInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkFenceGetFdInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkFenceGetFdInfoKHR.create(address, capacity);
    }

    public static VkFenceGetFdInfoKHR mallocStack() {
        return VkFenceGetFdInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkFenceGetFdInfoKHR callocStack() {
        return VkFenceGetFdInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkFenceGetFdInfoKHR mallocStack(MemoryStack stack) {
        return VkFenceGetFdInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkFenceGetFdInfoKHR callocStack(MemoryStack stack) {
        return VkFenceGetFdInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkFenceGetFdInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkFenceGetFdInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkFenceGetFdInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkFenceGetFdInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nfence(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FENCE);
    }

    public static int nhandleType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nfence(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)FENCE, value);
    }

    public static void nhandleType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPE, value);
    }

    static {
        Struct.Layout layout = VkFenceGetFdInfoKHR.__struct(VkFenceGetFdInfoKHR.__member(4), VkFenceGetFdInfoKHR.__member(POINTER_SIZE), VkFenceGetFdInfoKHR.__member(8), VkFenceGetFdInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FENCE = layout.offsetof(2);
        HANDLETYPE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkFenceGetFdInfoKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkFenceGetFdInfoKHR newInstance(long address) {
            return new VkFenceGetFdInfoKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkFenceGetFdInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkFenceGetFdInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkFence")
        public long fence() {
            return VkFenceGetFdInfoKHR.nfence(this.address());
        }

        @NativeType(value="VkExternalFenceHandleTypeFlagBits")
        public int handleType() {
            return VkFenceGetFdInfoKHR.nhandleType(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkFenceGetFdInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkFenceGetFdInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer fence(@NativeType(value="VkFence") long value) {
            VkFenceGetFdInfoKHR.nfence(this.address(), value);
            return this;
        }

        public Buffer handleType(@NativeType(value="VkExternalFenceHandleTypeFlagBits") int value) {
            VkFenceGetFdInfoKHR.nhandleType(this.address(), value);
            return this;
        }
    }
}

