/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkExternalMemoryBufferCreateInfo;

public class VkExternalMemoryBufferCreateInfoKHR
extends VkExternalMemoryBufferCreateInfo {
    VkExternalMemoryBufferCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkExternalMemoryBufferCreateInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExternalMemoryBufferCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkExternalMemoryBufferCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkExternalMemoryBufferCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryBufferCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkExternalMemoryBufferCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryBufferCreateInfoKHR handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExternalMemoryBufferCreateInfoKHR.nhandleTypes(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryBufferCreateInfoKHR set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExternalMemoryBufferCreateInfoKHR set(VkExternalMemoryBufferCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalMemoryBufferCreateInfoKHR malloc() {
        return VkExternalMemoryBufferCreateInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfoKHR calloc() {
        return VkExternalMemoryBufferCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfoKHR create() {
        return new VkExternalMemoryBufferCreateInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfoKHR create(long address) {
        return new VkExternalMemoryBufferCreateInfoKHR(address, null);
    }

    @Nullable
    public static VkExternalMemoryBufferCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkExternalMemoryBufferCreateInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalMemoryBufferCreateInfoKHR.create(VkExternalMemoryBufferCreateInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalMemoryBufferCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkExternalMemoryBufferCreateInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExternalMemoryBufferCreateInfoKHR.create(address, capacity);
    }

    public static VkExternalMemoryBufferCreateInfoKHR mallocStack() {
        return VkExternalMemoryBufferCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryBufferCreateInfoKHR callocStack() {
        return VkExternalMemoryBufferCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryBufferCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfoKHR callocStack(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkExternalMemoryBufferCreateInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExternalMemoryBufferCreateInfoKHR newInstance(long address) {
            return new VkExternalMemoryBufferCreateInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalMemoryBufferCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExternalMemoryBufferCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExternalMemoryBufferCreateInfoKHR.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

