/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExternalMemoryBufferCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    VkExternalMemoryBufferCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkExternalMemoryBufferCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExternalMemoryBufferCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExternalMemoryBufferCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExternalMemoryBufferCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlags")
    public int handleTypes() {
        return VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address());
    }

    public VkExternalMemoryBufferCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkExternalMemoryBufferCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkExternalMemoryBufferCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo set(VkExternalMemoryBufferCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalMemoryBufferCreateInfo malloc() {
        return VkExternalMemoryBufferCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfo calloc() {
        return VkExternalMemoryBufferCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfo create() {
        return new VkExternalMemoryBufferCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfo create(long address) {
        return new VkExternalMemoryBufferCreateInfo(address, null);
    }

    @Nullable
    public static VkExternalMemoryBufferCreateInfo createSafe(long address) {
        return address == 0L ? null : VkExternalMemoryBufferCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalMemoryBufferCreateInfo.create(VkExternalMemoryBufferCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalMemoryBufferCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkExternalMemoryBufferCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExternalMemoryBufferCreateInfo.create(address, capacity);
    }

    public static VkExternalMemoryBufferCreateInfo mallocStack() {
        return VkExternalMemoryBufferCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryBufferCreateInfo callocStack() {
        return VkExternalMemoryBufferCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkExternalMemoryBufferCreateInfo mallocStack(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfo callocStack(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleTypes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPES, value);
    }

    static {
        Struct.Layout layout = VkExternalMemoryBufferCreateInfo.__struct(VkExternalMemoryBufferCreateInfo.__member(4), VkExternalMemoryBufferCreateInfo.__member(POINTER_SIZE), VkExternalMemoryBufferCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalMemoryBufferCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExternalMemoryBufferCreateInfo newInstance(long address) {
            return new VkExternalMemoryBufferCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExternalMemoryBufferCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExternalMemoryBufferCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlags")
        public int handleTypes() {
            return VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalMemoryBufferCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExternalMemoryBufferCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

