/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExternalFenceProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int EXPORTFROMIMPORTEDHANDLETYPES;
    public static final int COMPATIBLEHANDLETYPES;
    public static final int EXTERNALFENCEFEATURES;

    VkExternalFenceProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkExternalFenceProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExternalFenceProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExternalFenceProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkExternalFenceProperties.npNext(this.address());
    }

    @NativeType(value="VkExternalFenceHandleTypeFlags")
    public int exportFromImportedHandleTypes() {
        return VkExternalFenceProperties.nexportFromImportedHandleTypes(this.address());
    }

    @NativeType(value="VkExternalFenceHandleTypeFlags")
    public int compatibleHandleTypes() {
        return VkExternalFenceProperties.ncompatibleHandleTypes(this.address());
    }

    @NativeType(value="VkExternalFenceFeatureFlags")
    public int externalFenceFeatures() {
        return VkExternalFenceProperties.nexternalFenceFeatures(this.address());
    }

    public VkExternalFenceProperties sType(@NativeType(value="VkStructureType") int value) {
        VkExternalFenceProperties.nsType(this.address(), value);
        return this;
    }

    public VkExternalFenceProperties pNext(@NativeType(value="void *") long value) {
        VkExternalFenceProperties.npNext(this.address(), value);
        return this;
    }

    public VkExternalFenceProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkExternalFenceProperties set(VkExternalFenceProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalFenceProperties malloc() {
        return VkExternalFenceProperties.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExternalFenceProperties calloc() {
        return VkExternalFenceProperties.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExternalFenceProperties create() {
        return new VkExternalFenceProperties(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExternalFenceProperties create(long address) {
        return new VkExternalFenceProperties(address, null);
    }

    @Nullable
    public static VkExternalFenceProperties createSafe(long address) {
        return address == 0L ? null : VkExternalFenceProperties.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalFenceProperties.create(VkExternalFenceProperties.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalFenceProperties.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkExternalFenceProperties.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExternalFenceProperties.create(address, capacity);
    }

    public static VkExternalFenceProperties mallocStack() {
        return VkExternalFenceProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkExternalFenceProperties callocStack() {
        return VkExternalFenceProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkExternalFenceProperties mallocStack(MemoryStack stack) {
        return VkExternalFenceProperties.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalFenceProperties callocStack(MemoryStack stack) {
        return VkExternalFenceProperties.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExternalFenceProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExternalFenceProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalFenceProperties.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalFenceProperties.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nexportFromImportedHandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EXPORTFROMIMPORTEDHANDLETYPES);
    }

    public static int ncompatibleHandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPATIBLEHANDLETYPES);
    }

    public static int nexternalFenceFeatures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EXTERNALFENCEFEATURES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkExternalFenceProperties.__struct(VkExternalFenceProperties.__member(4), VkExternalFenceProperties.__member(POINTER_SIZE), VkExternalFenceProperties.__member(4), VkExternalFenceProperties.__member(4), VkExternalFenceProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        EXPORTFROMIMPORTEDHANDLETYPES = layout.offsetof(2);
        COMPATIBLEHANDLETYPES = layout.offsetof(3);
        EXTERNALFENCEFEATURES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkExternalFenceProperties, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExternalFenceProperties newInstance(long address) {
            return new VkExternalFenceProperties(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExternalFenceProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkExternalFenceProperties.npNext(this.address());
        }

        @NativeType(value="VkExternalFenceHandleTypeFlags")
        public int exportFromImportedHandleTypes() {
            return VkExternalFenceProperties.nexportFromImportedHandleTypes(this.address());
        }

        @NativeType(value="VkExternalFenceHandleTypeFlags")
        public int compatibleHandleTypes() {
            return VkExternalFenceProperties.ncompatibleHandleTypes(this.address());
        }

        @NativeType(value="VkExternalFenceFeatureFlags")
        public int externalFenceFeatures() {
            return VkExternalFenceProperties.nexternalFenceFeatures(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalFenceProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkExternalFenceProperties.npNext(this.address(), value);
            return this;
        }
    }
}

