/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExternalMemoryProperties;

public class VkExternalBufferProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int EXTERNALMEMORYPROPERTIES;

    VkExternalBufferProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkExternalBufferProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExternalBufferProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExternalBufferProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkExternalBufferProperties.npNext(this.address());
    }

    public VkExternalMemoryProperties externalMemoryProperties() {
        return VkExternalBufferProperties.nexternalMemoryProperties(this.address());
    }

    public VkExternalBufferProperties sType(@NativeType(value="VkStructureType") int value) {
        VkExternalBufferProperties.nsType(this.address(), value);
        return this;
    }

    public VkExternalBufferProperties pNext(@NativeType(value="void *") long value) {
        VkExternalBufferProperties.npNext(this.address(), value);
        return this;
    }

    public VkExternalBufferProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkExternalBufferProperties set(VkExternalBufferProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalBufferProperties malloc() {
        return VkExternalBufferProperties.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExternalBufferProperties calloc() {
        return VkExternalBufferProperties.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExternalBufferProperties create() {
        return new VkExternalBufferProperties(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExternalBufferProperties create(long address) {
        return new VkExternalBufferProperties(address, null);
    }

    @Nullable
    public static VkExternalBufferProperties createSafe(long address) {
        return address == 0L ? null : VkExternalBufferProperties.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalBufferProperties.create(VkExternalBufferProperties.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalBufferProperties.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkExternalBufferProperties.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExternalBufferProperties.create(address, capacity);
    }

    public static VkExternalBufferProperties mallocStack() {
        return VkExternalBufferProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkExternalBufferProperties callocStack() {
        return VkExternalBufferProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkExternalBufferProperties mallocStack(MemoryStack stack) {
        return VkExternalBufferProperties.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalBufferProperties callocStack(MemoryStack stack) {
        return VkExternalBufferProperties.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExternalBufferProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExternalBufferProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalBufferProperties.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalBufferProperties.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkExternalMemoryProperties nexternalMemoryProperties(long struct) {
        return VkExternalMemoryProperties.create(struct + (long)EXTERNALMEMORYPROPERTIES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkExternalBufferProperties.__struct(VkExternalBufferProperties.__member(4), VkExternalBufferProperties.__member(POINTER_SIZE), VkExternalBufferProperties.__member(VkExternalMemoryProperties.SIZEOF, VkExternalMemoryProperties.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        EXTERNALMEMORYPROPERTIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalBufferProperties, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExternalBufferProperties newInstance(long address) {
            return new VkExternalBufferProperties(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExternalBufferProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkExternalBufferProperties.npNext(this.address());
        }

        public VkExternalMemoryProperties externalMemoryProperties() {
            return VkExternalBufferProperties.nexternalMemoryProperties(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalBufferProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkExternalBufferProperties.npNext(this.address(), value);
            return this;
        }
    }
}

