/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExportMemoryAllocateInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    VkExportMemoryAllocateInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkExportMemoryAllocateInfoNV(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExportMemoryAllocateInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExportMemoryAllocateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExportMemoryAllocateInfoNV.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
    public int handleTypes() {
        return VkExportMemoryAllocateInfoNV.nhandleTypes(this.address());
    }

    public VkExportMemoryAllocateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkExportMemoryAllocateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkExportMemoryAllocateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkExportMemoryAllocateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkExportMemoryAllocateInfoNV handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlagsNV") int value) {
        VkExportMemoryAllocateInfoNV.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExportMemoryAllocateInfoNV set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExportMemoryAllocateInfoNV set(VkExportMemoryAllocateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExportMemoryAllocateInfoNV malloc() {
        return VkExportMemoryAllocateInfoNV.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExportMemoryAllocateInfoNV calloc() {
        return VkExportMemoryAllocateInfoNV.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExportMemoryAllocateInfoNV create() {
        return new VkExportMemoryAllocateInfoNV(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExportMemoryAllocateInfoNV create(long address) {
        return new VkExportMemoryAllocateInfoNV(address, null);
    }

    @Nullable
    public static VkExportMemoryAllocateInfoNV createSafe(long address) {
        return address == 0L ? null : VkExportMemoryAllocateInfoNV.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkExportMemoryAllocateInfoNV.create(VkExportMemoryAllocateInfoNV.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExportMemoryAllocateInfoNV.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkExportMemoryAllocateInfoNV.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExportMemoryAllocateInfoNV.create(address, capacity);
    }

    public static VkExportMemoryAllocateInfoNV mallocStack() {
        return VkExportMemoryAllocateInfoNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkExportMemoryAllocateInfoNV callocStack() {
        return VkExportMemoryAllocateInfoNV.callocStack(MemoryStack.stackGet());
    }

    public static VkExportMemoryAllocateInfoNV mallocStack(MemoryStack stack) {
        return VkExportMemoryAllocateInfoNV.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExportMemoryAllocateInfoNV callocStack(MemoryStack stack) {
        return VkExportMemoryAllocateInfoNV.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExportMemoryAllocateInfoNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExportMemoryAllocateInfoNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfoNV.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfoNV.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleTypes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPES, value);
    }

    static {
        Struct.Layout layout = VkExportMemoryAllocateInfoNV.__struct(VkExportMemoryAllocateInfoNV.__member(4), VkExportMemoryAllocateInfoNV.__member(POINTER_SIZE), VkExportMemoryAllocateInfoNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExportMemoryAllocateInfoNV, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExportMemoryAllocateInfoNV newInstance(long address) {
            return new VkExportMemoryAllocateInfoNV(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExportMemoryAllocateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExportMemoryAllocateInfoNV.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
        public int handleTypes() {
            return VkExportMemoryAllocateInfoNV.nhandleTypes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExportMemoryAllocateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExportMemoryAllocateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlagsNV") int value) {
            VkExportMemoryAllocateInfoNV.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

