/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkExportMemoryAllocateInfo;

public class VkExportMemoryAllocateInfoKHR
extends VkExportMemoryAllocateInfo {
    VkExportMemoryAllocateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkExportMemoryAllocateInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExportMemoryAllocateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkExportMemoryAllocateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkExportMemoryAllocateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkExportMemoryAllocateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkExportMemoryAllocateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkExportMemoryAllocateInfoKHR handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExportMemoryAllocateInfoKHR.nhandleTypes(this.address(), value);
        return this;
    }

    @Override
    public VkExportMemoryAllocateInfoKHR set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExportMemoryAllocateInfoKHR set(VkExportMemoryAllocateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExportMemoryAllocateInfoKHR malloc() {
        return VkExportMemoryAllocateInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExportMemoryAllocateInfoKHR calloc() {
        return VkExportMemoryAllocateInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExportMemoryAllocateInfoKHR create() {
        return new VkExportMemoryAllocateInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExportMemoryAllocateInfoKHR create(long address) {
        return new VkExportMemoryAllocateInfoKHR(address, null);
    }

    @Nullable
    public static VkExportMemoryAllocateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkExportMemoryAllocateInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkExportMemoryAllocateInfoKHR.create(VkExportMemoryAllocateInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExportMemoryAllocateInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkExportMemoryAllocateInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExportMemoryAllocateInfoKHR.create(address, capacity);
    }

    public static VkExportMemoryAllocateInfoKHR mallocStack() {
        return VkExportMemoryAllocateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkExportMemoryAllocateInfoKHR callocStack() {
        return VkExportMemoryAllocateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkExportMemoryAllocateInfoKHR mallocStack(MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExportMemoryAllocateInfoKHR callocStack(MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExportMemoryAllocateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExportMemoryAllocateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkExportMemoryAllocateInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExportMemoryAllocateInfoKHR newInstance(long address) {
            return new VkExportMemoryAllocateInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExportMemoryAllocateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExportMemoryAllocateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExportMemoryAllocateInfoKHR.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

