/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkExportFenceCreateInfo;

public class VkExportFenceCreateInfoKHR
extends VkExportFenceCreateInfo {
    VkExportFenceCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkExportFenceCreateInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkExportFenceCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkExportFenceCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkExportFenceCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkExportFenceCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkExportFenceCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkExportFenceCreateInfoKHR handleTypes(@NativeType(value="VkExternalFenceHandleTypeFlags") int value) {
        VkExportFenceCreateInfoKHR.nhandleTypes(this.address(), value);
        return this;
    }

    @Override
    public VkExportFenceCreateInfoKHR set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExportFenceCreateInfoKHR set(VkExportFenceCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExportFenceCreateInfoKHR malloc() {
        return VkExportFenceCreateInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExportFenceCreateInfoKHR calloc() {
        return VkExportFenceCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExportFenceCreateInfoKHR create() {
        return new VkExportFenceCreateInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkExportFenceCreateInfoKHR create(long address) {
        return new VkExportFenceCreateInfoKHR(address, null);
    }

    @Nullable
    public static VkExportFenceCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkExportFenceCreateInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkExportFenceCreateInfoKHR.create(VkExportFenceCreateInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExportFenceCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkExportFenceCreateInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExportFenceCreateInfoKHR.create(address, capacity);
    }

    public static VkExportFenceCreateInfoKHR mallocStack() {
        return VkExportFenceCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkExportFenceCreateInfoKHR callocStack() {
        return VkExportFenceCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkExportFenceCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkExportFenceCreateInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExportFenceCreateInfoKHR callocStack(MemoryStack stack) {
        return VkExportFenceCreateInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExportFenceCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExportFenceCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExportFenceCreateInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExportFenceCreateInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkExportFenceCreateInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkExportFenceCreateInfoKHR newInstance(long address) {
            return new VkExportFenceCreateInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExportFenceCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExportFenceCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer handleTypes(@NativeType(value="VkExternalFenceHandleTypeFlags") int value) {
            VkExportFenceCreateInfoKHR.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

