/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkEventCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;

    VkEventCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkEventCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkEventCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkEventCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkEventCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkEventCreateFlags")
    public int flags() {
        return VkEventCreateInfo.nflags(this.address());
    }

    public VkEventCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkEventCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkEventCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkEventCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkEventCreateInfo flags(@NativeType(value="VkEventCreateFlags") int value) {
        VkEventCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkEventCreateInfo set(int sType, long pNext, int flags) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        return this;
    }

    public VkEventCreateInfo set(VkEventCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkEventCreateInfo malloc() {
        return VkEventCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkEventCreateInfo calloc() {
        return VkEventCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkEventCreateInfo create() {
        return new VkEventCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkEventCreateInfo create(long address) {
        return new VkEventCreateInfo(address, null);
    }

    @Nullable
    public static VkEventCreateInfo createSafe(long address) {
        return address == 0L ? null : VkEventCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkEventCreateInfo.create(VkEventCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkEventCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkEventCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkEventCreateInfo.create(address, capacity);
    }

    public static VkEventCreateInfo mallocStack() {
        return VkEventCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkEventCreateInfo callocStack() {
        return VkEventCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkEventCreateInfo mallocStack(MemoryStack stack) {
        return VkEventCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkEventCreateInfo callocStack(MemoryStack stack) {
        return VkEventCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkEventCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkEventCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkEventCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkEventCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkEventCreateInfo.__struct(VkEventCreateInfo.__member(4), VkEventCreateInfo.__member(POINTER_SIZE), VkEventCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkEventCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkEventCreateInfo newInstance(long address) {
            return new VkEventCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkEventCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkEventCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkEventCreateFlags")
        public int flags() {
            return VkEventCreateInfo.nflags(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkEventCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkEventCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkEventCreateFlags") int value) {
            VkEventCreateInfo.nflags(this.address(), value);
            return this;
        }
    }
}

