/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkDisplayModeParametersKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VISIBLEREGION;
    public static final int REFRESHRATE;

    VkDisplayModeParametersKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDisplayModeParametersKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDisplayModeParametersKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkExtent2D visibleRegion() {
        return VkDisplayModeParametersKHR.nvisibleRegion(this.address());
    }

    public VkDisplayModeParametersKHR visibleRegion(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.visibleRegion());
        return this;
    }

    @NativeType(value="uint32_t")
    public int refreshRate() {
        return VkDisplayModeParametersKHR.nrefreshRate(this.address());
    }

    public VkDisplayModeParametersKHR visibleRegion(VkExtent2D value) {
        VkDisplayModeParametersKHR.nvisibleRegion(this.address(), value);
        return this;
    }

    public VkDisplayModeParametersKHR refreshRate(@NativeType(value="uint32_t") int value) {
        VkDisplayModeParametersKHR.nrefreshRate(this.address(), value);
        return this;
    }

    public VkDisplayModeParametersKHR set(VkExtent2D visibleRegion, int refreshRate) {
        this.visibleRegion(visibleRegion);
        this.refreshRate(refreshRate);
        return this;
    }

    public VkDisplayModeParametersKHR set(VkDisplayModeParametersKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDisplayModeParametersKHR malloc() {
        return VkDisplayModeParametersKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDisplayModeParametersKHR calloc() {
        return VkDisplayModeParametersKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDisplayModeParametersKHR create() {
        return new VkDisplayModeParametersKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDisplayModeParametersKHR create(long address) {
        return new VkDisplayModeParametersKHR(address, null);
    }

    @Nullable
    public static VkDisplayModeParametersKHR createSafe(long address) {
        return address == 0L ? null : VkDisplayModeParametersKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDisplayModeParametersKHR.create(VkDisplayModeParametersKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDisplayModeParametersKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDisplayModeParametersKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDisplayModeParametersKHR.create(address, capacity);
    }

    public static VkDisplayModeParametersKHR mallocStack() {
        return VkDisplayModeParametersKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDisplayModeParametersKHR callocStack() {
        return VkDisplayModeParametersKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDisplayModeParametersKHR mallocStack(MemoryStack stack) {
        return VkDisplayModeParametersKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplayModeParametersKHR callocStack(MemoryStack stack) {
        return VkDisplayModeParametersKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDisplayModeParametersKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDisplayModeParametersKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayModeParametersKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayModeParametersKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkExtent2D nvisibleRegion(long struct) {
        return VkExtent2D.create(struct + (long)VISIBLEREGION);
    }

    public static int nrefreshRate(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REFRESHRATE);
    }

    public static void nvisibleRegion(long struct, VkExtent2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VISIBLEREGION, VkExtent2D.SIZEOF);
    }

    public static void nrefreshRate(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REFRESHRATE, value);
    }

    static {
        Struct.Layout layout = VkDisplayModeParametersKHR.__struct(VkDisplayModeParametersKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkDisplayModeParametersKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VISIBLEREGION = layout.offsetof(0);
        REFRESHRATE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayModeParametersKHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDisplayModeParametersKHR newInstance(long address) {
            return new VkDisplayModeParametersKHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public VkExtent2D visibleRegion() {
            return VkDisplayModeParametersKHR.nvisibleRegion(this.address());
        }

        public Buffer visibleRegion(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.visibleRegion());
            return this;
        }

        @NativeType(value="uint32_t")
        public int refreshRate() {
            return VkDisplayModeParametersKHR.nrefreshRate(this.address());
        }

        public Buffer visibleRegion(VkExtent2D value) {
            VkDisplayModeParametersKHR.nvisibleRegion(this.address(), value);
            return this;
        }

        public Buffer refreshRate(@NativeType(value="uint32_t") int value) {
            VkDisplayModeParametersKHR.nrefreshRate(this.address(), value);
            return this;
        }
    }
}

