/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkDeviceGroupDeviceCreateInfo;

public class VkDeviceGroupDeviceCreateInfoKHR
extends VkDeviceGroupDeviceCreateInfo {
    VkDeviceGroupDeviceCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDeviceGroupDeviceCreateInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDeviceGroupDeviceCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkDeviceGroupDeviceCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupDeviceCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupDeviceCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupDeviceCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupDeviceCreateInfoKHR pPhysicalDevices(@Nullable @NativeType(value="VkPhysicalDevice const *") PointerBuffer value) {
        VkDeviceGroupDeviceCreateInfoKHR.npPhysicalDevices(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupDeviceCreateInfoKHR set(int sType, long pNext, @Nullable PointerBuffer pPhysicalDevices) {
        this.sType(sType);
        this.pNext(pNext);
        this.pPhysicalDevices(pPhysicalDevices);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfoKHR set(VkDeviceGroupDeviceCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupDeviceCreateInfoKHR malloc() {
        return VkDeviceGroupDeviceCreateInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceGroupDeviceCreateInfoKHR calloc() {
        return VkDeviceGroupDeviceCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceGroupDeviceCreateInfoKHR create() {
        return new VkDeviceGroupDeviceCreateInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDeviceGroupDeviceCreateInfoKHR create(long address) {
        return new VkDeviceGroupDeviceCreateInfoKHR(address, null);
    }

    @Nullable
    public static VkDeviceGroupDeviceCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkDeviceGroupDeviceCreateInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceGroupDeviceCreateInfoKHR.create(VkDeviceGroupDeviceCreateInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceGroupDeviceCreateInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDeviceGroupDeviceCreateInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceGroupDeviceCreateInfoKHR.create(address, capacity);
    }

    public static VkDeviceGroupDeviceCreateInfoKHR mallocStack() {
        return VkDeviceGroupDeviceCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupDeviceCreateInfoKHR callocStack() {
        return VkDeviceGroupDeviceCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupDeviceCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupDeviceCreateInfoKHR callocStack(MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupDeviceCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupDeviceCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkDeviceGroupDeviceCreateInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDeviceGroupDeviceCreateInfoKHR newInstance(long address) {
            return new VkDeviceGroupDeviceCreateInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupDeviceCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupDeviceCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer pPhysicalDevices(@Nullable @NativeType(value="VkPhysicalDevice const *") PointerBuffer value) {
            VkDeviceGroupDeviceCreateInfoKHR.npPhysicalDevices(this.address(), value);
            return this;
        }
    }
}

