/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDescriptorUpdateTemplateEntry;

public class VkDescriptorUpdateTemplateCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DESCRIPTORUPDATEENTRYCOUNT;
    public static final int PDESCRIPTORUPDATEENTRIES;
    public static final int TEMPLATETYPE;
    public static final int DESCRIPTORSETLAYOUT;
    public static final int PIPELINEBINDPOINT;
    public static final int PIPELINELAYOUT;
    public static final int SET;

    VkDescriptorUpdateTemplateCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDescriptorUpdateTemplateCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDescriptorUpdateTemplateCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDescriptorUpdateTemplateCreateInfo.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkDescriptorUpdateTemplateCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkDescriptorUpdateTemplateCreateFlags")
    public int flags() {
        return VkDescriptorUpdateTemplateCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorUpdateEntryCount() {
        return VkDescriptorUpdateTemplateCreateInfo.ndescriptorUpdateEntryCount(this.address());
    }

    @NativeType(value="VkDescriptorUpdateTemplateEntry const *")
    public VkDescriptorUpdateTemplateEntry.Buffer pDescriptorUpdateEntries() {
        return VkDescriptorUpdateTemplateCreateInfo.npDescriptorUpdateEntries(this.address());
    }

    @NativeType(value="VkDescriptorUpdateTemplateType")
    public int templateType() {
        return VkDescriptorUpdateTemplateCreateInfo.ntemplateType(this.address());
    }

    @NativeType(value="VkDescriptorSetLayout")
    public long descriptorSetLayout() {
        return VkDescriptorUpdateTemplateCreateInfo.ndescriptorSetLayout(this.address());
    }

    @NativeType(value="VkPipelineBindPoint")
    public int pipelineBindPoint() {
        return VkDescriptorUpdateTemplateCreateInfo.npipelineBindPoint(this.address());
    }

    @NativeType(value="VkPipelineLayout")
    public long pipelineLayout() {
        return VkDescriptorUpdateTemplateCreateInfo.npipelineLayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int set() {
        return VkDescriptorUpdateTemplateCreateInfo.nset(this.address());
    }

    public VkDescriptorUpdateTemplateCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDescriptorUpdateTemplateCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateCreateInfo pNext(@NativeType(value="void *") long value) {
        VkDescriptorUpdateTemplateCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateCreateInfo flags(@NativeType(value="VkDescriptorUpdateTemplateCreateFlags") int value) {
        VkDescriptorUpdateTemplateCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateCreateInfo pDescriptorUpdateEntries(@NativeType(value="VkDescriptorUpdateTemplateEntry const *") VkDescriptorUpdateTemplateEntry.Buffer value) {
        VkDescriptorUpdateTemplateCreateInfo.npDescriptorUpdateEntries(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateCreateInfo templateType(@NativeType(value="VkDescriptorUpdateTemplateType") int value) {
        VkDescriptorUpdateTemplateCreateInfo.ntemplateType(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateCreateInfo descriptorSetLayout(@NativeType(value="VkDescriptorSetLayout") long value) {
        VkDescriptorUpdateTemplateCreateInfo.ndescriptorSetLayout(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateCreateInfo pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
        VkDescriptorUpdateTemplateCreateInfo.npipelineBindPoint(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateCreateInfo pipelineLayout(@NativeType(value="VkPipelineLayout") long value) {
        VkDescriptorUpdateTemplateCreateInfo.npipelineLayout(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateCreateInfo set(@NativeType(value="uint32_t") int value) {
        VkDescriptorUpdateTemplateCreateInfo.nset(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateCreateInfo set(int sType, long pNext, int flags, VkDescriptorUpdateTemplateEntry.Buffer pDescriptorUpdateEntries, int templateType, long descriptorSetLayout, int pipelineBindPoint, long pipelineLayout, int set) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pDescriptorUpdateEntries(pDescriptorUpdateEntries);
        this.templateType(templateType);
        this.descriptorSetLayout(descriptorSetLayout);
        this.pipelineBindPoint(pipelineBindPoint);
        this.pipelineLayout(pipelineLayout);
        this.set(set);
        return this;
    }

    public VkDescriptorUpdateTemplateCreateInfo set(VkDescriptorUpdateTemplateCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorUpdateTemplateCreateInfo malloc() {
        return VkDescriptorUpdateTemplateCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDescriptorUpdateTemplateCreateInfo calloc() {
        return VkDescriptorUpdateTemplateCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDescriptorUpdateTemplateCreateInfo create() {
        return new VkDescriptorUpdateTemplateCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDescriptorUpdateTemplateCreateInfo create(long address) {
        return new VkDescriptorUpdateTemplateCreateInfo(address, null);
    }

    @Nullable
    public static VkDescriptorUpdateTemplateCreateInfo createSafe(long address) {
        return address == 0L ? null : VkDescriptorUpdateTemplateCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDescriptorUpdateTemplateCreateInfo.create(VkDescriptorUpdateTemplateCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDescriptorUpdateTemplateCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDescriptorUpdateTemplateCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDescriptorUpdateTemplateCreateInfo.create(address, capacity);
    }

    public static VkDescriptorUpdateTemplateCreateInfo mallocStack() {
        return VkDescriptorUpdateTemplateCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorUpdateTemplateCreateInfo callocStack() {
        return VkDescriptorUpdateTemplateCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorUpdateTemplateCreateInfo mallocStack(MemoryStack stack) {
        return VkDescriptorUpdateTemplateCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorUpdateTemplateCreateInfo callocStack(MemoryStack stack) {
        return VkDescriptorUpdateTemplateCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDescriptorUpdateTemplateCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDescriptorUpdateTemplateCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorUpdateTemplateCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorUpdateTemplateCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int ndescriptorUpdateEntryCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DESCRIPTORUPDATEENTRYCOUNT);
    }

    public static VkDescriptorUpdateTemplateEntry.Buffer npDescriptorUpdateEntries(long struct) {
        return VkDescriptorUpdateTemplateEntry.create(MemoryUtil.memGetAddress(struct + (long)PDESCRIPTORUPDATEENTRIES), VkDescriptorUpdateTemplateCreateInfo.ndescriptorUpdateEntryCount(struct));
    }

    public static int ntemplateType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEMPLATETYPE);
    }

    public static long ndescriptorSetLayout(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DESCRIPTORSETLAYOUT);
    }

    public static int npipelineBindPoint(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PIPELINEBINDPOINT);
    }

    public static long npipelineLayout(long struct) {
        return MemoryUtil.memGetLong(struct + (long)PIPELINELAYOUT);
    }

    public static int nset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SET);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void ndescriptorUpdateEntryCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DESCRIPTORUPDATEENTRYCOUNT, value);
    }

    public static void npDescriptorUpdateEntries(long struct, VkDescriptorUpdateTemplateEntry.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDESCRIPTORUPDATEENTRIES, value.address());
        VkDescriptorUpdateTemplateCreateInfo.ndescriptorUpdateEntryCount(struct, value.remaining());
    }

    public static void ntemplateType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TEMPLATETYPE, value);
    }

    public static void ndescriptorSetLayout(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DESCRIPTORSETLAYOUT, value);
    }

    public static void npipelineBindPoint(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PIPELINEBINDPOINT, value);
    }

    public static void npipelineLayout(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)PIPELINELAYOUT, value);
    }

    public static void nset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SET, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PDESCRIPTORUPDATEENTRIES));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDescriptorUpdateTemplateCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDescriptorUpdateTemplateCreateInfo.__struct(VkDescriptorUpdateTemplateCreateInfo.__member(4), VkDescriptorUpdateTemplateCreateInfo.__member(POINTER_SIZE), VkDescriptorUpdateTemplateCreateInfo.__member(4), VkDescriptorUpdateTemplateCreateInfo.__member(4), VkDescriptorUpdateTemplateCreateInfo.__member(POINTER_SIZE), VkDescriptorUpdateTemplateCreateInfo.__member(4), VkDescriptorUpdateTemplateCreateInfo.__member(8), VkDescriptorUpdateTemplateCreateInfo.__member(4), VkDescriptorUpdateTemplateCreateInfo.__member(8), VkDescriptorUpdateTemplateCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DESCRIPTORUPDATEENTRYCOUNT = layout.offsetof(3);
        PDESCRIPTORUPDATEENTRIES = layout.offsetof(4);
        TEMPLATETYPE = layout.offsetof(5);
        DESCRIPTORSETLAYOUT = layout.offsetof(6);
        PIPELINEBINDPOINT = layout.offsetof(7);
        PIPELINELAYOUT = layout.offsetof(8);
        SET = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorUpdateTemplateCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDescriptorUpdateTemplateCreateInfo newInstance(long address) {
            return new VkDescriptorUpdateTemplateCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDescriptorUpdateTemplateCreateInfo.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkDescriptorUpdateTemplateCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkDescriptorUpdateTemplateCreateFlags")
        public int flags() {
            return VkDescriptorUpdateTemplateCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorUpdateEntryCount() {
            return VkDescriptorUpdateTemplateCreateInfo.ndescriptorUpdateEntryCount(this.address());
        }

        @NativeType(value="VkDescriptorUpdateTemplateEntry const *")
        public VkDescriptorUpdateTemplateEntry.Buffer pDescriptorUpdateEntries() {
            return VkDescriptorUpdateTemplateCreateInfo.npDescriptorUpdateEntries(this.address());
        }

        @NativeType(value="VkDescriptorUpdateTemplateType")
        public int templateType() {
            return VkDescriptorUpdateTemplateCreateInfo.ntemplateType(this.address());
        }

        @NativeType(value="VkDescriptorSetLayout")
        public long descriptorSetLayout() {
            return VkDescriptorUpdateTemplateCreateInfo.ndescriptorSetLayout(this.address());
        }

        @NativeType(value="VkPipelineBindPoint")
        public int pipelineBindPoint() {
            return VkDescriptorUpdateTemplateCreateInfo.npipelineBindPoint(this.address());
        }

        @NativeType(value="VkPipelineLayout")
        public long pipelineLayout() {
            return VkDescriptorUpdateTemplateCreateInfo.npipelineLayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int set() {
            return VkDescriptorUpdateTemplateCreateInfo.nset(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDescriptorUpdateTemplateCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkDescriptorUpdateTemplateCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDescriptorUpdateTemplateCreateFlags") int value) {
            VkDescriptorUpdateTemplateCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pDescriptorUpdateEntries(@NativeType(value="VkDescriptorUpdateTemplateEntry const *") VkDescriptorUpdateTemplateEntry.Buffer value) {
            VkDescriptorUpdateTemplateCreateInfo.npDescriptorUpdateEntries(this.address(), value);
            return this;
        }

        public Buffer templateType(@NativeType(value="VkDescriptorUpdateTemplateType") int value) {
            VkDescriptorUpdateTemplateCreateInfo.ntemplateType(this.address(), value);
            return this;
        }

        public Buffer descriptorSetLayout(@NativeType(value="VkDescriptorSetLayout") long value) {
            VkDescriptorUpdateTemplateCreateInfo.ndescriptorSetLayout(this.address(), value);
            return this;
        }

        public Buffer pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
            VkDescriptorUpdateTemplateCreateInfo.npipelineBindPoint(this.address(), value);
            return this;
        }

        public Buffer pipelineLayout(@NativeType(value="VkPipelineLayout") long value) {
            VkDescriptorUpdateTemplateCreateInfo.npipelineLayout(this.address(), value);
            return this;
        }

        public Buffer set(@NativeType(value="uint32_t") int value) {
            VkDescriptorUpdateTemplateCreateInfo.nset(this.address(), value);
            return this;
        }
    }
}

