/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkDescriptorSetLayoutSupport;

public class VkDescriptorSetLayoutSupportKHR
extends VkDescriptorSetLayoutSupport {
    VkDescriptorSetLayoutSupportKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDescriptorSetLayoutSupportKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDescriptorSetLayoutSupportKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkDescriptorSetLayoutSupportKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDescriptorSetLayoutSupportKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkDescriptorSetLayoutSupportKHR pNext(@NativeType(value="void *") long value) {
        VkDescriptorSetLayoutSupportKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkDescriptorSetLayoutSupportKHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkDescriptorSetLayoutSupportKHR set(VkDescriptorSetLayoutSupportKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorSetLayoutSupportKHR malloc() {
        return VkDescriptorSetLayoutSupportKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDescriptorSetLayoutSupportKHR calloc() {
        return VkDescriptorSetLayoutSupportKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDescriptorSetLayoutSupportKHR create() {
        return new VkDescriptorSetLayoutSupportKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDescriptorSetLayoutSupportKHR create(long address) {
        return new VkDescriptorSetLayoutSupportKHR(address, null);
    }

    @Nullable
    public static VkDescriptorSetLayoutSupportKHR createSafe(long address) {
        return address == 0L ? null : VkDescriptorSetLayoutSupportKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDescriptorSetLayoutSupportKHR.create(VkDescriptorSetLayoutSupportKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDescriptorSetLayoutSupportKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDescriptorSetLayoutSupportKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDescriptorSetLayoutSupportKHR.create(address, capacity);
    }

    public static VkDescriptorSetLayoutSupportKHR mallocStack() {
        return VkDescriptorSetLayoutSupportKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorSetLayoutSupportKHR callocStack() {
        return VkDescriptorSetLayoutSupportKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorSetLayoutSupportKHR mallocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutSupportKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorSetLayoutSupportKHR callocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutSupportKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDescriptorSetLayoutSupportKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDescriptorSetLayoutSupportKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutSupportKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutSupportKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkDescriptorSetLayoutSupport.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDescriptorSetLayoutSupportKHR newInstance(long address) {
            return new VkDescriptorSetLayoutSupportKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDescriptorSetLayoutSupportKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void *") long value) {
            VkDescriptorSetLayoutSupportKHR.npNext(this.address(), value);
            return this;
        }
    }
}

