/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorPoolSize
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int DESCRIPTORCOUNT;

    VkDescriptorPoolSize(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDescriptorPoolSize(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDescriptorPoolSize.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDescriptorType")
    public int type() {
        return VkDescriptorPoolSize.ntype(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorCount() {
        return VkDescriptorPoolSize.ndescriptorCount(this.address());
    }

    public VkDescriptorPoolSize type(@NativeType(value="VkDescriptorType") int value) {
        VkDescriptorPoolSize.ntype(this.address(), value);
        return this;
    }

    public VkDescriptorPoolSize descriptorCount(@NativeType(value="uint32_t") int value) {
        VkDescriptorPoolSize.ndescriptorCount(this.address(), value);
        return this;
    }

    public VkDescriptorPoolSize set(int type, int descriptorCount) {
        this.type(type);
        this.descriptorCount(descriptorCount);
        return this;
    }

    public VkDescriptorPoolSize set(VkDescriptorPoolSize src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorPoolSize malloc() {
        return VkDescriptorPoolSize.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDescriptorPoolSize calloc() {
        return VkDescriptorPoolSize.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDescriptorPoolSize create() {
        return new VkDescriptorPoolSize(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDescriptorPoolSize create(long address) {
        return new VkDescriptorPoolSize(address, null);
    }

    @Nullable
    public static VkDescriptorPoolSize createSafe(long address) {
        return address == 0L ? null : VkDescriptorPoolSize.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDescriptorPoolSize.create(VkDescriptorPoolSize.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDescriptorPoolSize.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDescriptorPoolSize.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDescriptorPoolSize.create(address, capacity);
    }

    public static VkDescriptorPoolSize mallocStack() {
        return VkDescriptorPoolSize.mallocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorPoolSize callocStack() {
        return VkDescriptorPoolSize.callocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorPoolSize mallocStack(MemoryStack stack) {
        return VkDescriptorPoolSize.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorPoolSize callocStack(MemoryStack stack) {
        return VkDescriptorPoolSize.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDescriptorPoolSize.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDescriptorPoolSize.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorPoolSize.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorPoolSize.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int ndescriptorCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DESCRIPTORCOUNT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void ndescriptorCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DESCRIPTORCOUNT, value);
    }

    static {
        Struct.Layout layout = VkDescriptorPoolSize.__struct(VkDescriptorPoolSize.__member(4), VkDescriptorPoolSize.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        DESCRIPTORCOUNT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorPoolSize, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDescriptorPoolSize newInstance(long address) {
            return new VkDescriptorPoolSize(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkDescriptorType")
        public int type() {
            return VkDescriptorPoolSize.ntype(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorCount() {
            return VkDescriptorPoolSize.ndescriptorCount(this.address());
        }

        public Buffer type(@NativeType(value="VkDescriptorType") int value) {
            VkDescriptorPoolSize.ntype(this.address(), value);
            return this;
        }

        public Buffer descriptorCount(@NativeType(value="uint32_t") int value) {
            VkDescriptorPoolSize.ndescriptorCount(this.address(), value);
            return this;
        }
    }
}

