/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDedicatedAllocationMemoryAllocateInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int IMAGE;
    public static final int BUFFER;

    VkDedicatedAllocationMemoryAllocateInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDedicatedAllocationMemoryAllocateInfoNV(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDedicatedAllocationMemoryAllocateInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDedicatedAllocationMemoryAllocateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDedicatedAllocationMemoryAllocateInfoNV.npNext(this.address());
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkDedicatedAllocationMemoryAllocateInfoNV.nimage(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkDedicatedAllocationMemoryAllocateInfoNV.nbuffer(this.address());
    }

    public VkDedicatedAllocationMemoryAllocateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkDedicatedAllocationMemoryAllocateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkDedicatedAllocationMemoryAllocateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkDedicatedAllocationMemoryAllocateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkDedicatedAllocationMemoryAllocateInfoNV image(@NativeType(value="VkImage") long value) {
        VkDedicatedAllocationMemoryAllocateInfoNV.nimage(this.address(), value);
        return this;
    }

    public VkDedicatedAllocationMemoryAllocateInfoNV buffer(@NativeType(value="VkBuffer") long value) {
        VkDedicatedAllocationMemoryAllocateInfoNV.nbuffer(this.address(), value);
        return this;
    }

    public VkDedicatedAllocationMemoryAllocateInfoNV set(int sType, long pNext, long image, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        this.buffer(buffer);
        return this;
    }

    public VkDedicatedAllocationMemoryAllocateInfoNV set(VkDedicatedAllocationMemoryAllocateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDedicatedAllocationMemoryAllocateInfoNV malloc() {
        return VkDedicatedAllocationMemoryAllocateInfoNV.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDedicatedAllocationMemoryAllocateInfoNV calloc() {
        return VkDedicatedAllocationMemoryAllocateInfoNV.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDedicatedAllocationMemoryAllocateInfoNV create() {
        return new VkDedicatedAllocationMemoryAllocateInfoNV(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDedicatedAllocationMemoryAllocateInfoNV create(long address) {
        return new VkDedicatedAllocationMemoryAllocateInfoNV(address, null);
    }

    @Nullable
    public static VkDedicatedAllocationMemoryAllocateInfoNV createSafe(long address) {
        return address == 0L ? null : VkDedicatedAllocationMemoryAllocateInfoNV.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDedicatedAllocationMemoryAllocateInfoNV.create(VkDedicatedAllocationMemoryAllocateInfoNV.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDedicatedAllocationMemoryAllocateInfoNV.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDedicatedAllocationMemoryAllocateInfoNV.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDedicatedAllocationMemoryAllocateInfoNV.create(address, capacity);
    }

    public static VkDedicatedAllocationMemoryAllocateInfoNV mallocStack() {
        return VkDedicatedAllocationMemoryAllocateInfoNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkDedicatedAllocationMemoryAllocateInfoNV callocStack() {
        return VkDedicatedAllocationMemoryAllocateInfoNV.callocStack(MemoryStack.stackGet());
    }

    public static VkDedicatedAllocationMemoryAllocateInfoNV mallocStack(MemoryStack stack) {
        return VkDedicatedAllocationMemoryAllocateInfoNV.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDedicatedAllocationMemoryAllocateInfoNV callocStack(MemoryStack stack) {
        return VkDedicatedAllocationMemoryAllocateInfoNV.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDedicatedAllocationMemoryAllocateInfoNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDedicatedAllocationMemoryAllocateInfoNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDedicatedAllocationMemoryAllocateInfoNV.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDedicatedAllocationMemoryAllocateInfoNV.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nimage(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGE);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFER);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nimage(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)IMAGE, value);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFER, value);
    }

    static {
        Struct.Layout layout = VkDedicatedAllocationMemoryAllocateInfoNV.__struct(VkDedicatedAllocationMemoryAllocateInfoNV.__member(4), VkDedicatedAllocationMemoryAllocateInfoNV.__member(POINTER_SIZE), VkDedicatedAllocationMemoryAllocateInfoNV.__member(8), VkDedicatedAllocationMemoryAllocateInfoNV.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        IMAGE = layout.offsetof(2);
        BUFFER = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDedicatedAllocationMemoryAllocateInfoNV, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDedicatedAllocationMemoryAllocateInfoNV newInstance(long address) {
            return new VkDedicatedAllocationMemoryAllocateInfoNV(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDedicatedAllocationMemoryAllocateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDedicatedAllocationMemoryAllocateInfoNV.npNext(this.address());
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkDedicatedAllocationMemoryAllocateInfoNV.nimage(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkDedicatedAllocationMemoryAllocateInfoNV.nbuffer(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDedicatedAllocationMemoryAllocateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDedicatedAllocationMemoryAllocateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkDedicatedAllocationMemoryAllocateInfoNV.nimage(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkDedicatedAllocationMemoryAllocateInfoNV.nbuffer(this.address(), value);
            return this;
        }
    }
}

