/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDedicatedAllocationBufferCreateInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEDICATEDALLOCATION;

    VkDedicatedAllocationBufferCreateInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDedicatedAllocationBufferCreateInfoNV(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDedicatedAllocationBufferCreateInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDedicatedAllocationBufferCreateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDedicatedAllocationBufferCreateInfoNV.npNext(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean dedicatedAllocation() {
        return VkDedicatedAllocationBufferCreateInfoNV.ndedicatedAllocation(this.address()) != 0;
    }

    public VkDedicatedAllocationBufferCreateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkDedicatedAllocationBufferCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkDedicatedAllocationBufferCreateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkDedicatedAllocationBufferCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkDedicatedAllocationBufferCreateInfoNV dedicatedAllocation(@NativeType(value="VkBool32") boolean value) {
        VkDedicatedAllocationBufferCreateInfoNV.ndedicatedAllocation(this.address(), value ? 1 : 0);
        return this;
    }

    public VkDedicatedAllocationBufferCreateInfoNV set(int sType, long pNext, boolean dedicatedAllocation) {
        this.sType(sType);
        this.pNext(pNext);
        this.dedicatedAllocation(dedicatedAllocation);
        return this;
    }

    public VkDedicatedAllocationBufferCreateInfoNV set(VkDedicatedAllocationBufferCreateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDedicatedAllocationBufferCreateInfoNV malloc() {
        return VkDedicatedAllocationBufferCreateInfoNV.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDedicatedAllocationBufferCreateInfoNV calloc() {
        return VkDedicatedAllocationBufferCreateInfoNV.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDedicatedAllocationBufferCreateInfoNV create() {
        return new VkDedicatedAllocationBufferCreateInfoNV(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDedicatedAllocationBufferCreateInfoNV create(long address) {
        return new VkDedicatedAllocationBufferCreateInfoNV(address, null);
    }

    @Nullable
    public static VkDedicatedAllocationBufferCreateInfoNV createSafe(long address) {
        return address == 0L ? null : VkDedicatedAllocationBufferCreateInfoNV.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDedicatedAllocationBufferCreateInfoNV.create(VkDedicatedAllocationBufferCreateInfoNV.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDedicatedAllocationBufferCreateInfoNV.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDedicatedAllocationBufferCreateInfoNV.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDedicatedAllocationBufferCreateInfoNV.create(address, capacity);
    }

    public static VkDedicatedAllocationBufferCreateInfoNV mallocStack() {
        return VkDedicatedAllocationBufferCreateInfoNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkDedicatedAllocationBufferCreateInfoNV callocStack() {
        return VkDedicatedAllocationBufferCreateInfoNV.callocStack(MemoryStack.stackGet());
    }

    public static VkDedicatedAllocationBufferCreateInfoNV mallocStack(MemoryStack stack) {
        return VkDedicatedAllocationBufferCreateInfoNV.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDedicatedAllocationBufferCreateInfoNV callocStack(MemoryStack stack) {
        return VkDedicatedAllocationBufferCreateInfoNV.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDedicatedAllocationBufferCreateInfoNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDedicatedAllocationBufferCreateInfoNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDedicatedAllocationBufferCreateInfoNV.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDedicatedAllocationBufferCreateInfoNV.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ndedicatedAllocation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEDICATEDALLOCATION);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndedicatedAllocation(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEDICATEDALLOCATION, value);
    }

    static {
        Struct.Layout layout = VkDedicatedAllocationBufferCreateInfoNV.__struct(VkDedicatedAllocationBufferCreateInfoNV.__member(4), VkDedicatedAllocationBufferCreateInfoNV.__member(POINTER_SIZE), VkDedicatedAllocationBufferCreateInfoNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEDICATEDALLOCATION = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDedicatedAllocationBufferCreateInfoNV, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDedicatedAllocationBufferCreateInfoNV newInstance(long address) {
            return new VkDedicatedAllocationBufferCreateInfoNV(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDedicatedAllocationBufferCreateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDedicatedAllocationBufferCreateInfoNV.npNext(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean dedicatedAllocation() {
            return VkDedicatedAllocationBufferCreateInfoNV.ndedicatedAllocation(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDedicatedAllocationBufferCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDedicatedAllocationBufferCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer dedicatedAllocation(@NativeType(value="VkBool32") boolean value) {
            VkDedicatedAllocationBufferCreateInfoNV.ndedicatedAllocation(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

