/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDebugUtilsMessengerCallbackEXT;
import org.lwjgl.vulkan.VkDebugUtilsMessengerCallbackEXTI;

public class VkDebugUtilsMessengerCreateInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int MESSAGESEVERITY;
    public static final int MESSAGETYPE;
    public static final int PFNUSERCALLBACK;
    public static final int PUSERDATA;

    VkDebugUtilsMessengerCreateInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDebugUtilsMessengerCreateInfoEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDebugUtilsMessengerCreateInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDebugUtilsMessengerCreateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDebugUtilsMessengerCreateInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkDebugUtilsMessengerCreateFlagsEXT")
    public int flags() {
        return VkDebugUtilsMessengerCreateInfoEXT.nflags(this.address());
    }

    @NativeType(value="VkDebugUtilsMessageSeverityFlagsEXT")
    public int messageSeverity() {
        return VkDebugUtilsMessengerCreateInfoEXT.nmessageSeverity(this.address());
    }

    @NativeType(value="VkDebugUtilsMessageTypeFlagsEXT")
    public int messageType() {
        return VkDebugUtilsMessengerCreateInfoEXT.nmessageType(this.address());
    }

    @NativeType(value="PFN_vkDebugUtilsMessengerCallbackEXT")
    public VkDebugUtilsMessengerCallbackEXT pfnUserCallback() {
        return VkDebugUtilsMessengerCreateInfoEXT.npfnUserCallback(this.address());
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VkDebugUtilsMessengerCreateInfoEXT.npUserData(this.address());
    }

    public VkDebugUtilsMessengerCreateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDebugUtilsMessengerCreateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCreateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDebugUtilsMessengerCreateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCreateInfoEXT flags(@NativeType(value="VkDebugUtilsMessengerCreateFlagsEXT") int value) {
        VkDebugUtilsMessengerCreateInfoEXT.nflags(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCreateInfoEXT messageSeverity(@NativeType(value="VkDebugUtilsMessageSeverityFlagsEXT") int value) {
        VkDebugUtilsMessengerCreateInfoEXT.nmessageSeverity(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCreateInfoEXT messageType(@NativeType(value="VkDebugUtilsMessageTypeFlagsEXT") int value) {
        VkDebugUtilsMessengerCreateInfoEXT.nmessageType(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCreateInfoEXT pfnUserCallback(@NativeType(value="PFN_vkDebugUtilsMessengerCallbackEXT") VkDebugUtilsMessengerCallbackEXTI value) {
        VkDebugUtilsMessengerCreateInfoEXT.npfnUserCallback(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCreateInfoEXT pUserData(@NativeType(value="void *") long value) {
        VkDebugUtilsMessengerCreateInfoEXT.npUserData(this.address(), value);
        return this;
    }

    public VkDebugUtilsMessengerCreateInfoEXT set(int sType, long pNext, int flags, int messageSeverity, int messageType, VkDebugUtilsMessengerCallbackEXTI pfnUserCallback, long pUserData) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.messageSeverity(messageSeverity);
        this.messageType(messageType);
        this.pfnUserCallback(pfnUserCallback);
        this.pUserData(pUserData);
        return this;
    }

    public VkDebugUtilsMessengerCreateInfoEXT set(VkDebugUtilsMessengerCreateInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDebugUtilsMessengerCreateInfoEXT malloc() {
        return VkDebugUtilsMessengerCreateInfoEXT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDebugUtilsMessengerCreateInfoEXT calloc() {
        return VkDebugUtilsMessengerCreateInfoEXT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDebugUtilsMessengerCreateInfoEXT create() {
        return new VkDebugUtilsMessengerCreateInfoEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDebugUtilsMessengerCreateInfoEXT create(long address) {
        return new VkDebugUtilsMessengerCreateInfoEXT(address, null);
    }

    @Nullable
    public static VkDebugUtilsMessengerCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : VkDebugUtilsMessengerCreateInfoEXT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDebugUtilsMessengerCreateInfoEXT.create(VkDebugUtilsMessengerCreateInfoEXT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDebugUtilsMessengerCreateInfoEXT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDebugUtilsMessengerCreateInfoEXT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDebugUtilsMessengerCreateInfoEXT.create(address, capacity);
    }

    public static VkDebugUtilsMessengerCreateInfoEXT mallocStack() {
        return VkDebugUtilsMessengerCreateInfoEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkDebugUtilsMessengerCreateInfoEXT callocStack() {
        return VkDebugUtilsMessengerCreateInfoEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkDebugUtilsMessengerCreateInfoEXT mallocStack(MemoryStack stack) {
        return VkDebugUtilsMessengerCreateInfoEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDebugUtilsMessengerCreateInfoEXT callocStack(MemoryStack stack) {
        return VkDebugUtilsMessengerCreateInfoEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDebugUtilsMessengerCreateInfoEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDebugUtilsMessengerCreateInfoEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDebugUtilsMessengerCreateInfoEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDebugUtilsMessengerCreateInfoEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nmessageSeverity(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MESSAGESEVERITY);
    }

    public static int nmessageType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MESSAGETYPE);
    }

    public static VkDebugUtilsMessengerCallbackEXT npfnUserCallback(long struct) {
        return VkDebugUtilsMessengerCallbackEXT.create(MemoryUtil.memGetAddress(struct + (long)PFNUSERCALLBACK));
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PUSERDATA);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nmessageSeverity(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MESSAGESEVERITY, value);
    }

    public static void nmessageType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MESSAGETYPE, value);
    }

    public static void npfnUserCallback(long struct, VkDebugUtilsMessengerCallbackEXTI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNUSERCALLBACK, value.address());
    }

    public static void npUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PUSERDATA, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PFNUSERCALLBACK));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDebugUtilsMessengerCreateInfoEXT.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDebugUtilsMessengerCreateInfoEXT.__struct(VkDebugUtilsMessengerCreateInfoEXT.__member(4), VkDebugUtilsMessengerCreateInfoEXT.__member(POINTER_SIZE), VkDebugUtilsMessengerCreateInfoEXT.__member(4), VkDebugUtilsMessengerCreateInfoEXT.__member(4), VkDebugUtilsMessengerCreateInfoEXT.__member(4), VkDebugUtilsMessengerCreateInfoEXT.__member(POINTER_SIZE), VkDebugUtilsMessengerCreateInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        MESSAGESEVERITY = layout.offsetof(3);
        MESSAGETYPE = layout.offsetof(4);
        PFNUSERCALLBACK = layout.offsetof(5);
        PUSERDATA = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkDebugUtilsMessengerCreateInfoEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDebugUtilsMessengerCreateInfoEXT newInstance(long address) {
            return new VkDebugUtilsMessengerCreateInfoEXT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDebugUtilsMessengerCreateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDebugUtilsMessengerCreateInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkDebugUtilsMessengerCreateFlagsEXT")
        public int flags() {
            return VkDebugUtilsMessengerCreateInfoEXT.nflags(this.address());
        }

        @NativeType(value="VkDebugUtilsMessageSeverityFlagsEXT")
        public int messageSeverity() {
            return VkDebugUtilsMessengerCreateInfoEXT.nmessageSeverity(this.address());
        }

        @NativeType(value="VkDebugUtilsMessageTypeFlagsEXT")
        public int messageType() {
            return VkDebugUtilsMessengerCreateInfoEXT.nmessageType(this.address());
        }

        @NativeType(value="PFN_vkDebugUtilsMessengerCallbackEXT")
        public VkDebugUtilsMessengerCallbackEXT pfnUserCallback() {
            return VkDebugUtilsMessengerCreateInfoEXT.npfnUserCallback(this.address());
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VkDebugUtilsMessengerCreateInfoEXT.npUserData(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDebugUtilsMessengerCreateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDebugUtilsMessengerCreateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDebugUtilsMessengerCreateFlagsEXT") int value) {
            VkDebugUtilsMessengerCreateInfoEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer messageSeverity(@NativeType(value="VkDebugUtilsMessageSeverityFlagsEXT") int value) {
            VkDebugUtilsMessengerCreateInfoEXT.nmessageSeverity(this.address(), value);
            return this;
        }

        public Buffer messageType(@NativeType(value="VkDebugUtilsMessageTypeFlagsEXT") int value) {
            VkDebugUtilsMessengerCreateInfoEXT.nmessageType(this.address(), value);
            return this;
        }

        public Buffer pfnUserCallback(@NativeType(value="PFN_vkDebugUtilsMessengerCallbackEXT") VkDebugUtilsMessengerCallbackEXTI value) {
            VkDebugUtilsMessengerCreateInfoEXT.npfnUserCallback(this.address(), value);
            return this;
        }

        public Buffer pUserData(@NativeType(value="void *") long value) {
            VkDebugUtilsMessengerCreateInfoEXT.npUserData(this.address(), value);
            return this;
        }
    }
}

