/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDebugUtilsLabelEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PLABELNAME;
    public static final int COLOR;

    VkDebugUtilsLabelEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkDebugUtilsLabelEXT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDebugUtilsLabelEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDebugUtilsLabelEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDebugUtilsLabelEXT.npNext(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer pLabelName() {
        return VkDebugUtilsLabelEXT.npLabelName(this.address());
    }

    @NativeType(value="char const *")
    public String pLabelNameString() {
        return VkDebugUtilsLabelEXT.npLabelNameString(this.address());
    }

    @NativeType(value="float[4]")
    public FloatBuffer color() {
        return VkDebugUtilsLabelEXT.ncolor(this.address());
    }

    public float color(int index) {
        return VkDebugUtilsLabelEXT.ncolor(this.address(), index);
    }

    public VkDebugUtilsLabelEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDebugUtilsLabelEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugUtilsLabelEXT pNext(@NativeType(value="void const *") long value) {
        VkDebugUtilsLabelEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugUtilsLabelEXT pLabelName(@NativeType(value="char const *") ByteBuffer value) {
        VkDebugUtilsLabelEXT.npLabelName(this.address(), value);
        return this;
    }

    public VkDebugUtilsLabelEXT color(@NativeType(value="float[4]") FloatBuffer value) {
        VkDebugUtilsLabelEXT.ncolor(this.address(), value);
        return this;
    }

    public VkDebugUtilsLabelEXT color(int index, float value) {
        VkDebugUtilsLabelEXT.ncolor(this.address(), index, value);
        return this;
    }

    public VkDebugUtilsLabelEXT set(int sType, long pNext, ByteBuffer pLabelName, FloatBuffer color) {
        this.sType(sType);
        this.pNext(pNext);
        this.pLabelName(pLabelName);
        this.color(color);
        return this;
    }

    public VkDebugUtilsLabelEXT set(VkDebugUtilsLabelEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDebugUtilsLabelEXT malloc() {
        return VkDebugUtilsLabelEXT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDebugUtilsLabelEXT calloc() {
        return VkDebugUtilsLabelEXT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDebugUtilsLabelEXT create() {
        return new VkDebugUtilsLabelEXT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDebugUtilsLabelEXT create(long address) {
        return new VkDebugUtilsLabelEXT(address, null);
    }

    @Nullable
    public static VkDebugUtilsLabelEXT createSafe(long address) {
        return address == 0L ? null : VkDebugUtilsLabelEXT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkDebugUtilsLabelEXT.create(VkDebugUtilsLabelEXT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDebugUtilsLabelEXT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkDebugUtilsLabelEXT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDebugUtilsLabelEXT.create(address, capacity);
    }

    public static VkDebugUtilsLabelEXT mallocStack() {
        return VkDebugUtilsLabelEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkDebugUtilsLabelEXT callocStack() {
        return VkDebugUtilsLabelEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkDebugUtilsLabelEXT mallocStack(MemoryStack stack) {
        return VkDebugUtilsLabelEXT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDebugUtilsLabelEXT callocStack(MemoryStack stack) {
        return VkDebugUtilsLabelEXT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDebugUtilsLabelEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDebugUtilsLabelEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDebugUtilsLabelEXT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDebugUtilsLabelEXT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static ByteBuffer npLabelName(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)PLABELNAME));
    }

    public static String npLabelNameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)PLABELNAME));
    }

    public static FloatBuffer ncolor(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)COLOR, 4);
    }

    public static float ncolor(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)COLOR + Checks.check(index, 4) * 4L);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npLabelName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PLABELNAME, MemoryUtil.memAddress(value));
    }

    public static void ncolor(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)COLOR, value.remaining() * 4);
    }

    public static void ncolor(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)COLOR + Checks.check(index, 4) * 4L, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PLABELNAME));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDebugUtilsLabelEXT.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkDebugUtilsLabelEXT.__struct(VkDebugUtilsLabelEXT.__member(4), VkDebugUtilsLabelEXT.__member(POINTER_SIZE), VkDebugUtilsLabelEXT.__member(POINTER_SIZE), VkDebugUtilsLabelEXT.__array(4, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PLABELNAME = layout.offsetof(2);
        COLOR = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDebugUtilsLabelEXT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDebugUtilsLabelEXT newInstance(long address) {
            return new VkDebugUtilsLabelEXT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDebugUtilsLabelEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDebugUtilsLabelEXT.npNext(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer pLabelName() {
            return VkDebugUtilsLabelEXT.npLabelName(this.address());
        }

        @NativeType(value="char const *")
        public String pLabelNameString() {
            return VkDebugUtilsLabelEXT.npLabelNameString(this.address());
        }

        @NativeType(value="float[4]")
        public FloatBuffer color() {
            return VkDebugUtilsLabelEXT.ncolor(this.address());
        }

        public float color(int index) {
            return VkDebugUtilsLabelEXT.ncolor(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDebugUtilsLabelEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDebugUtilsLabelEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pLabelName(@NativeType(value="char const *") ByteBuffer value) {
            VkDebugUtilsLabelEXT.npLabelName(this.address(), value);
            return this;
        }

        public Buffer color(@NativeType(value="float[4]") FloatBuffer value) {
            VkDebugUtilsLabelEXT.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(int index, float value) {
            VkDebugUtilsLabelEXT.ncolor(this.address(), index, value);
            return this;
        }
    }
}

