/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkClearDepthStencilValue
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEPTH;
    public static final int STENCIL;

    VkClearDepthStencilValue(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkClearDepthStencilValue(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkClearDepthStencilValue.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float depth() {
        return VkClearDepthStencilValue.ndepth(this.address());
    }

    @NativeType(value="uint32_t")
    public int stencil() {
        return VkClearDepthStencilValue.nstencil(this.address());
    }

    public VkClearDepthStencilValue depth(float value) {
        VkClearDepthStencilValue.ndepth(this.address(), value);
        return this;
    }

    public VkClearDepthStencilValue stencil(@NativeType(value="uint32_t") int value) {
        VkClearDepthStencilValue.nstencil(this.address(), value);
        return this;
    }

    public VkClearDepthStencilValue set(float depth, int stencil) {
        this.depth(depth);
        this.stencil(stencil);
        return this;
    }

    public VkClearDepthStencilValue set(VkClearDepthStencilValue src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkClearDepthStencilValue malloc() {
        return VkClearDepthStencilValue.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkClearDepthStencilValue calloc() {
        return VkClearDepthStencilValue.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkClearDepthStencilValue create() {
        return new VkClearDepthStencilValue(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkClearDepthStencilValue create(long address) {
        return new VkClearDepthStencilValue(address, null);
    }

    @Nullable
    public static VkClearDepthStencilValue createSafe(long address) {
        return address == 0L ? null : VkClearDepthStencilValue.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkClearDepthStencilValue.create(VkClearDepthStencilValue.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkClearDepthStencilValue.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkClearDepthStencilValue.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkClearDepthStencilValue.create(address, capacity);
    }

    public static VkClearDepthStencilValue mallocStack() {
        return VkClearDepthStencilValue.mallocStack(MemoryStack.stackGet());
    }

    public static VkClearDepthStencilValue callocStack() {
        return VkClearDepthStencilValue.callocStack(MemoryStack.stackGet());
    }

    public static VkClearDepthStencilValue mallocStack(MemoryStack stack) {
        return VkClearDepthStencilValue.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkClearDepthStencilValue callocStack(MemoryStack stack) {
        return VkClearDepthStencilValue.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkClearDepthStencilValue.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkClearDepthStencilValue.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkClearDepthStencilValue.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkClearDepthStencilValue.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float ndepth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DEPTH);
    }

    public static int nstencil(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STENCIL);
    }

    public static void ndepth(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DEPTH, value);
    }

    public static void nstencil(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STENCIL, value);
    }

    static {
        Struct.Layout layout = VkClearDepthStencilValue.__struct(VkClearDepthStencilValue.__member(4), VkClearDepthStencilValue.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEPTH = layout.offsetof(0);
        STENCIL = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkClearDepthStencilValue, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkClearDepthStencilValue newInstance(long address) {
            return new VkClearDepthStencilValue(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float depth() {
            return VkClearDepthStencilValue.ndepth(this.address());
        }

        @NativeType(value="uint32_t")
        public int stencil() {
            return VkClearDepthStencilValue.nstencil(this.address());
        }

        public Buffer depth(float value) {
            VkClearDepthStencilValue.ndepth(this.address(), value);
            return this;
        }

        public Buffer stencil(@NativeType(value="uint32_t") int value) {
            VkClearDepthStencilValue.nstencil(this.address(), value);
            return this;
        }
    }
}

