/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCheckpointDataNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int STAGE;
    public static final int PCHECKPOINTMARKER;

    VkCheckpointDataNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkCheckpointDataNV(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkCheckpointDataNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCheckpointDataNV.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkCheckpointDataNV.npNext(this.address());
    }

    @NativeType(value="VkPipelineStageFlagBits")
    public int stage() {
        return VkCheckpointDataNV.nstage(this.address());
    }

    @NativeType(value="void *")
    public long pCheckpointMarker() {
        return VkCheckpointDataNV.npCheckpointMarker(this.address());
    }

    public VkCheckpointDataNV sType(@NativeType(value="VkStructureType") int value) {
        VkCheckpointDataNV.nsType(this.address(), value);
        return this;
    }

    public VkCheckpointDataNV pNext(@NativeType(value="void *") long value) {
        VkCheckpointDataNV.npNext(this.address(), value);
        return this;
    }

    public VkCheckpointDataNV set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkCheckpointDataNV set(VkCheckpointDataNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCheckpointDataNV malloc() {
        return VkCheckpointDataNV.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkCheckpointDataNV calloc() {
        return VkCheckpointDataNV.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkCheckpointDataNV create() {
        return new VkCheckpointDataNV(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkCheckpointDataNV create(long address) {
        return new VkCheckpointDataNV(address, null);
    }

    @Nullable
    public static VkCheckpointDataNV createSafe(long address) {
        return address == 0L ? null : VkCheckpointDataNV.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkCheckpointDataNV.create(VkCheckpointDataNV.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkCheckpointDataNV.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkCheckpointDataNV.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkCheckpointDataNV.create(address, capacity);
    }

    public static VkCheckpointDataNV mallocStack() {
        return VkCheckpointDataNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkCheckpointDataNV callocStack() {
        return VkCheckpointDataNV.callocStack(MemoryStack.stackGet());
    }

    public static VkCheckpointDataNV mallocStack(MemoryStack stack) {
        return VkCheckpointDataNV.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCheckpointDataNV callocStack(MemoryStack stack) {
        return VkCheckpointDataNV.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkCheckpointDataNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkCheckpointDataNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkCheckpointDataNV.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkCheckpointDataNV.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nstage(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STAGE);
    }

    public static long npCheckpointMarker(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PCHECKPOINTMARKER);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkCheckpointDataNV.__struct(VkCheckpointDataNV.__member(4), VkCheckpointDataNV.__member(POINTER_SIZE), VkCheckpointDataNV.__member(4), VkCheckpointDataNV.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        STAGE = layout.offsetof(2);
        PCHECKPOINTMARKER = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkCheckpointDataNV, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkCheckpointDataNV newInstance(long address) {
            return new VkCheckpointDataNV(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCheckpointDataNV.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkCheckpointDataNV.npNext(this.address());
        }

        @NativeType(value="VkPipelineStageFlagBits")
        public int stage() {
            return VkCheckpointDataNV.nstage(this.address());
        }

        @NativeType(value="void *")
        public long pCheckpointMarker() {
            return VkCheckpointDataNV.npCheckpointMarker(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCheckpointDataNV.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkCheckpointDataNV.npNext(this.address(), value);
            return this;
        }
    }
}

