/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSparseBufferMemoryBindInfo;
import org.lwjgl.vulkan.VkSparseImageMemoryBindInfo;
import org.lwjgl.vulkan.VkSparseImageOpaqueMemoryBindInfo;

public class VkBindSparseInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int WAITSEMAPHORECOUNT;
    public static final int PWAITSEMAPHORES;
    public static final int BUFFERBINDCOUNT;
    public static final int PBUFFERBINDS;
    public static final int IMAGEOPAQUEBINDCOUNT;
    public static final int PIMAGEOPAQUEBINDS;
    public static final int IMAGEBINDCOUNT;
    public static final int PIMAGEBINDS;
    public static final int SIGNALSEMAPHORECOUNT;
    public static final int PSIGNALSEMAPHORES;

    VkBindSparseInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkBindSparseInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBindSparseInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindSparseInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindSparseInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int waitSemaphoreCount() {
        return VkBindSparseInfo.nwaitSemaphoreCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSemaphore const *")
    public LongBuffer pWaitSemaphores() {
        return VkBindSparseInfo.npWaitSemaphores(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferBindCount() {
        return VkBindSparseInfo.nbufferBindCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSparseBufferMemoryBindInfo const *")
    public VkSparseBufferMemoryBindInfo.Buffer pBufferBinds() {
        return VkBindSparseInfo.npBufferBinds(this.address());
    }

    @NativeType(value="uint32_t")
    public int imageOpaqueBindCount() {
        return VkBindSparseInfo.nimageOpaqueBindCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSparseImageOpaqueMemoryBindInfo const *")
    public VkSparseImageOpaqueMemoryBindInfo.Buffer pImageOpaqueBinds() {
        return VkBindSparseInfo.npImageOpaqueBinds(this.address());
    }

    @NativeType(value="uint32_t")
    public int imageBindCount() {
        return VkBindSparseInfo.nimageBindCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSparseImageMemoryBindInfo const *")
    public VkSparseImageMemoryBindInfo.Buffer pImageBinds() {
        return VkBindSparseInfo.npImageBinds(this.address());
    }

    @NativeType(value="uint32_t")
    public int signalSemaphoreCount() {
        return VkBindSparseInfo.nsignalSemaphoreCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSemaphore const *")
    public LongBuffer pSignalSemaphores() {
        return VkBindSparseInfo.npSignalSemaphores(this.address());
    }

    public VkBindSparseInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBindSparseInfo.nsType(this.address(), value);
        return this;
    }

    public VkBindSparseInfo pNext(@NativeType(value="void const *") long value) {
        VkBindSparseInfo.npNext(this.address(), value);
        return this;
    }

    public VkBindSparseInfo pWaitSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
        VkBindSparseInfo.npWaitSemaphores(this.address(), value);
        return this;
    }

    public VkBindSparseInfo pBufferBinds(@Nullable @NativeType(value="VkSparseBufferMemoryBindInfo const *") VkSparseBufferMemoryBindInfo.Buffer value) {
        VkBindSparseInfo.npBufferBinds(this.address(), value);
        return this;
    }

    public VkBindSparseInfo pImageOpaqueBinds(@Nullable @NativeType(value="VkSparseImageOpaqueMemoryBindInfo const *") VkSparseImageOpaqueMemoryBindInfo.Buffer value) {
        VkBindSparseInfo.npImageOpaqueBinds(this.address(), value);
        return this;
    }

    public VkBindSparseInfo pImageBinds(@Nullable @NativeType(value="VkSparseImageMemoryBindInfo const *") VkSparseImageMemoryBindInfo.Buffer value) {
        VkBindSparseInfo.npImageBinds(this.address(), value);
        return this;
    }

    public VkBindSparseInfo pSignalSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
        VkBindSparseInfo.npSignalSemaphores(this.address(), value);
        return this;
    }

    public VkBindSparseInfo set(int sType, long pNext, @Nullable LongBuffer pWaitSemaphores, @Nullable VkSparseBufferMemoryBindInfo.Buffer pBufferBinds, @Nullable VkSparseImageOpaqueMemoryBindInfo.Buffer pImageOpaqueBinds, @Nullable VkSparseImageMemoryBindInfo.Buffer pImageBinds, @Nullable LongBuffer pSignalSemaphores) {
        this.sType(sType);
        this.pNext(pNext);
        this.pWaitSemaphores(pWaitSemaphores);
        this.pBufferBinds(pBufferBinds);
        this.pImageOpaqueBinds(pImageOpaqueBinds);
        this.pImageBinds(pImageBinds);
        this.pSignalSemaphores(pSignalSemaphores);
        return this;
    }

    public VkBindSparseInfo set(VkBindSparseInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindSparseInfo malloc() {
        return VkBindSparseInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBindSparseInfo calloc() {
        return VkBindSparseInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBindSparseInfo create() {
        return new VkBindSparseInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBindSparseInfo create(long address) {
        return new VkBindSparseInfo(address, null);
    }

    @Nullable
    public static VkBindSparseInfo createSafe(long address) {
        return address == 0L ? null : VkBindSparseInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkBindSparseInfo.create(VkBindSparseInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBindSparseInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkBindSparseInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBindSparseInfo.create(address, capacity);
    }

    public static VkBindSparseInfo mallocStack() {
        return VkBindSparseInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkBindSparseInfo callocStack() {
        return VkBindSparseInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkBindSparseInfo mallocStack(MemoryStack stack) {
        return VkBindSparseInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindSparseInfo callocStack(MemoryStack stack) {
        return VkBindSparseInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBindSparseInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBindSparseInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindSparseInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindSparseInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nwaitSemaphoreCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WAITSEMAPHORECOUNT);
    }

    @Nullable
    public static LongBuffer npWaitSemaphores(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PWAITSEMAPHORES), VkBindSparseInfo.nwaitSemaphoreCount(struct));
    }

    public static int nbufferBindCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BUFFERBINDCOUNT);
    }

    @Nullable
    public static VkSparseBufferMemoryBindInfo.Buffer npBufferBinds(long struct) {
        return VkSparseBufferMemoryBindInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PBUFFERBINDS), VkBindSparseInfo.nbufferBindCount(struct));
    }

    public static int nimageOpaqueBindCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGEOPAQUEBINDCOUNT);
    }

    @Nullable
    public static VkSparseImageOpaqueMemoryBindInfo.Buffer npImageOpaqueBinds(long struct) {
        return VkSparseImageOpaqueMemoryBindInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PIMAGEOPAQUEBINDS), VkBindSparseInfo.nimageOpaqueBindCount(struct));
    }

    public static int nimageBindCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGEBINDCOUNT);
    }

    @Nullable
    public static VkSparseImageMemoryBindInfo.Buffer npImageBinds(long struct) {
        return VkSparseImageMemoryBindInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PIMAGEBINDS), VkBindSparseInfo.nimageBindCount(struct));
    }

    public static int nsignalSemaphoreCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIGNALSEMAPHORECOUNT);
    }

    @Nullable
    public static LongBuffer npSignalSemaphores(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PSIGNALSEMAPHORES), VkBindSparseInfo.nsignalSemaphoreCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nwaitSemaphoreCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WAITSEMAPHORECOUNT, value);
    }

    public static void npWaitSemaphores(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PWAITSEMAPHORES, MemoryUtil.memAddressSafe(value));
        VkBindSparseInfo.nwaitSemaphoreCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nbufferBindCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BUFFERBINDCOUNT, value);
    }

    public static void npBufferBinds(long struct, @Nullable VkSparseBufferMemoryBindInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PBUFFERBINDS, MemoryUtil.memAddressSafe(value));
        VkBindSparseInfo.nbufferBindCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nimageOpaqueBindCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGEOPAQUEBINDCOUNT, value);
    }

    public static void npImageOpaqueBinds(long struct, @Nullable VkSparseImageOpaqueMemoryBindInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PIMAGEOPAQUEBINDS, MemoryUtil.memAddressSafe(value));
        VkBindSparseInfo.nimageOpaqueBindCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nimageBindCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGEBINDCOUNT, value);
    }

    public static void npImageBinds(long struct, @Nullable VkSparseImageMemoryBindInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PIMAGEBINDS, MemoryUtil.memAddressSafe(value));
        VkBindSparseInfo.nimageBindCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nsignalSemaphoreCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIGNALSEMAPHORECOUNT, value);
    }

    public static void npSignalSemaphores(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSIGNALSEMAPHORES, MemoryUtil.memAddressSafe(value));
        VkBindSparseInfo.nsignalSemaphoreCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        int imageBindCount;
        int imageOpaqueBindCount;
        int bufferBindCount;
        if (VkBindSparseInfo.nwaitSemaphoreCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PWAITSEMAPHORES));
        }
        if ((bufferBindCount = VkBindSparseInfo.nbufferBindCount(struct)) != 0) {
            long pBufferBinds = MemoryUtil.memGetAddress(struct + (long)PBUFFERBINDS);
            Checks.check(pBufferBinds);
            VkSparseBufferMemoryBindInfo.validate(pBufferBinds, bufferBindCount);
        }
        if ((imageOpaqueBindCount = VkBindSparseInfo.nimageOpaqueBindCount(struct)) != 0) {
            long pImageOpaqueBinds = MemoryUtil.memGetAddress(struct + (long)PIMAGEOPAQUEBINDS);
            Checks.check(pImageOpaqueBinds);
            VkSparseImageOpaqueMemoryBindInfo.validate(pImageOpaqueBinds, imageOpaqueBindCount);
        }
        if ((imageBindCount = VkBindSparseInfo.nimageBindCount(struct)) != 0) {
            long pImageBinds = MemoryUtil.memGetAddress(struct + (long)PIMAGEBINDS);
            Checks.check(pImageBinds);
            VkSparseImageMemoryBindInfo.validate(pImageBinds, imageBindCount);
        }
        if (VkBindSparseInfo.nsignalSemaphoreCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PSIGNALSEMAPHORES));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkBindSparseInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkBindSparseInfo.__struct(VkBindSparseInfo.__member(4), VkBindSparseInfo.__member(POINTER_SIZE), VkBindSparseInfo.__member(4), VkBindSparseInfo.__member(POINTER_SIZE), VkBindSparseInfo.__member(4), VkBindSparseInfo.__member(POINTER_SIZE), VkBindSparseInfo.__member(4), VkBindSparseInfo.__member(POINTER_SIZE), VkBindSparseInfo.__member(4), VkBindSparseInfo.__member(POINTER_SIZE), VkBindSparseInfo.__member(4), VkBindSparseInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        WAITSEMAPHORECOUNT = layout.offsetof(2);
        PWAITSEMAPHORES = layout.offsetof(3);
        BUFFERBINDCOUNT = layout.offsetof(4);
        PBUFFERBINDS = layout.offsetof(5);
        IMAGEOPAQUEBINDCOUNT = layout.offsetof(6);
        PIMAGEOPAQUEBINDS = layout.offsetof(7);
        IMAGEBINDCOUNT = layout.offsetof(8);
        PIMAGEBINDS = layout.offsetof(9);
        SIGNALSEMAPHORECOUNT = layout.offsetof(10);
        PSIGNALSEMAPHORES = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<VkBindSparseInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBindSparseInfo newInstance(long address) {
            return new VkBindSparseInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindSparseInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindSparseInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int waitSemaphoreCount() {
            return VkBindSparseInfo.nwaitSemaphoreCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSemaphore const *")
        public LongBuffer pWaitSemaphores() {
            return VkBindSparseInfo.npWaitSemaphores(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferBindCount() {
            return VkBindSparseInfo.nbufferBindCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSparseBufferMemoryBindInfo const *")
        public VkSparseBufferMemoryBindInfo.Buffer pBufferBinds() {
            return VkBindSparseInfo.npBufferBinds(this.address());
        }

        @NativeType(value="uint32_t")
        public int imageOpaqueBindCount() {
            return VkBindSparseInfo.nimageOpaqueBindCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSparseImageOpaqueMemoryBindInfo const *")
        public VkSparseImageOpaqueMemoryBindInfo.Buffer pImageOpaqueBinds() {
            return VkBindSparseInfo.npImageOpaqueBinds(this.address());
        }

        @NativeType(value="uint32_t")
        public int imageBindCount() {
            return VkBindSparseInfo.nimageBindCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSparseImageMemoryBindInfo const *")
        public VkSparseImageMemoryBindInfo.Buffer pImageBinds() {
            return VkBindSparseInfo.npImageBinds(this.address());
        }

        @NativeType(value="uint32_t")
        public int signalSemaphoreCount() {
            return VkBindSparseInfo.nsignalSemaphoreCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSemaphore const *")
        public LongBuffer pSignalSemaphores() {
            return VkBindSparseInfo.npSignalSemaphores(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindSparseInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindSparseInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pWaitSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
            VkBindSparseInfo.npWaitSemaphores(this.address(), value);
            return this;
        }

        public Buffer pBufferBinds(@Nullable @NativeType(value="VkSparseBufferMemoryBindInfo const *") VkSparseBufferMemoryBindInfo.Buffer value) {
            VkBindSparseInfo.npBufferBinds(this.address(), value);
            return this;
        }

        public Buffer pImageOpaqueBinds(@Nullable @NativeType(value="VkSparseImageOpaqueMemoryBindInfo const *") VkSparseImageOpaqueMemoryBindInfo.Buffer value) {
            VkBindSparseInfo.npImageOpaqueBinds(this.address(), value);
            return this;
        }

        public Buffer pImageBinds(@Nullable @NativeType(value="VkSparseImageMemoryBindInfo const *") VkSparseImageMemoryBindInfo.Buffer value) {
            VkBindSparseInfo.npImageBinds(this.address(), value);
            return this;
        }

        public Buffer pSignalSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
            VkBindSparseInfo.npSignalSemaphores(this.address(), value);
            return this;
        }
    }
}

