/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindImagePlaneMemoryInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PLANEASPECT;

    VkBindImagePlaneMemoryInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkBindImagePlaneMemoryInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBindImagePlaneMemoryInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindImagePlaneMemoryInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindImagePlaneMemoryInfo.npNext(this.address());
    }

    @NativeType(value="VkImageAspectFlagBits")
    public int planeAspect() {
        return VkBindImagePlaneMemoryInfo.nplaneAspect(this.address());
    }

    public VkBindImagePlaneMemoryInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBindImagePlaneMemoryInfo.nsType(this.address(), value);
        return this;
    }

    public VkBindImagePlaneMemoryInfo pNext(@NativeType(value="void const *") long value) {
        VkBindImagePlaneMemoryInfo.npNext(this.address(), value);
        return this;
    }

    public VkBindImagePlaneMemoryInfo planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
        VkBindImagePlaneMemoryInfo.nplaneAspect(this.address(), value);
        return this;
    }

    public VkBindImagePlaneMemoryInfo set(int sType, long pNext, int planeAspect) {
        this.sType(sType);
        this.pNext(pNext);
        this.planeAspect(planeAspect);
        return this;
    }

    public VkBindImagePlaneMemoryInfo set(VkBindImagePlaneMemoryInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindImagePlaneMemoryInfo malloc() {
        return VkBindImagePlaneMemoryInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfo calloc() {
        return VkBindImagePlaneMemoryInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfo create() {
        return new VkBindImagePlaneMemoryInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfo create(long address) {
        return new VkBindImagePlaneMemoryInfo(address, null);
    }

    @Nullable
    public static VkBindImagePlaneMemoryInfo createSafe(long address) {
        return address == 0L ? null : VkBindImagePlaneMemoryInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkBindImagePlaneMemoryInfo.create(VkBindImagePlaneMemoryInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBindImagePlaneMemoryInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkBindImagePlaneMemoryInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBindImagePlaneMemoryInfo.create(address, capacity);
    }

    public static VkBindImagePlaneMemoryInfo mallocStack() {
        return VkBindImagePlaneMemoryInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkBindImagePlaneMemoryInfo callocStack() {
        return VkBindImagePlaneMemoryInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkBindImagePlaneMemoryInfo mallocStack(MemoryStack stack) {
        return VkBindImagePlaneMemoryInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfo callocStack(MemoryStack stack) {
        return VkBindImagePlaneMemoryInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBindImagePlaneMemoryInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBindImagePlaneMemoryInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindImagePlaneMemoryInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindImagePlaneMemoryInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nplaneAspect(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PLANEASPECT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nplaneAspect(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PLANEASPECT, value);
    }

    static {
        Struct.Layout layout = VkBindImagePlaneMemoryInfo.__struct(VkBindImagePlaneMemoryInfo.__member(4), VkBindImagePlaneMemoryInfo.__member(POINTER_SIZE), VkBindImagePlaneMemoryInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PLANEASPECT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBindImagePlaneMemoryInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBindImagePlaneMemoryInfo newInstance(long address) {
            return new VkBindImagePlaneMemoryInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindImagePlaneMemoryInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindImagePlaneMemoryInfo.npNext(this.address());
        }

        @NativeType(value="VkImageAspectFlagBits")
        public int planeAspect() {
            return VkBindImagePlaneMemoryInfo.nplaneAspect(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindImagePlaneMemoryInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindImagePlaneMemoryInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
            VkBindImagePlaneMemoryInfo.nplaneAspect(this.address(), value);
            return this;
        }
    }
}

