/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBindImageMemoryInfo;

public class VkBindImageMemoryInfoKHR
extends VkBindImageMemoryInfo {
    VkBindImageMemoryInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkBindImageMemoryInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBindImageMemoryInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkBindImageMemoryInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBindImageMemoryInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBindImageMemoryInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkBindImageMemoryInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBindImageMemoryInfoKHR image(@NativeType(value="VkImage") long value) {
        VkBindImageMemoryInfoKHR.nimage(this.address(), value);
        return this;
    }

    @Override
    public VkBindImageMemoryInfoKHR memory(@NativeType(value="VkDeviceMemory") long value) {
        VkBindImageMemoryInfoKHR.nmemory(this.address(), value);
        return this;
    }

    @Override
    public VkBindImageMemoryInfoKHR memoryOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBindImageMemoryInfoKHR.nmemoryOffset(this.address(), value);
        return this;
    }

    @Override
    public VkBindImageMemoryInfoKHR set(int sType, long pNext, long image, long memory, long memoryOffset) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        return this;
    }

    public VkBindImageMemoryInfoKHR set(VkBindImageMemoryInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindImageMemoryInfoKHR malloc() {
        return VkBindImageMemoryInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBindImageMemoryInfoKHR calloc() {
        return VkBindImageMemoryInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBindImageMemoryInfoKHR create() {
        return new VkBindImageMemoryInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBindImageMemoryInfoKHR create(long address) {
        return new VkBindImageMemoryInfoKHR(address, null);
    }

    @Nullable
    public static VkBindImageMemoryInfoKHR createSafe(long address) {
        return address == 0L ? null : VkBindImageMemoryInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkBindImageMemoryInfoKHR.create(VkBindImageMemoryInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBindImageMemoryInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkBindImageMemoryInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBindImageMemoryInfoKHR.create(address, capacity);
    }

    public static VkBindImageMemoryInfoKHR mallocStack() {
        return VkBindImageMemoryInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkBindImageMemoryInfoKHR callocStack() {
        return VkBindImageMemoryInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkBindImageMemoryInfoKHR mallocStack(MemoryStack stack) {
        return VkBindImageMemoryInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindImageMemoryInfoKHR callocStack(MemoryStack stack) {
        return VkBindImageMemoryInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBindImageMemoryInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBindImageMemoryInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindImageMemoryInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindImageMemoryInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBindImageMemoryInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBindImageMemoryInfoKHR newInstance(long address) {
            return new VkBindImageMemoryInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindImageMemoryInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindImageMemoryInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer image(@NativeType(value="VkImage") long value) {
            VkBindImageMemoryInfoKHR.nimage(this.address(), value);
            return this;
        }

        @Override
        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkBindImageMemoryInfoKHR.nmemory(this.address(), value);
            return this;
        }

        @Override
        public Buffer memoryOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBindImageMemoryInfoKHR.nmemoryOffset(this.address(), value);
            return this;
        }
    }
}

