/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBindImageMemoryDeviceGroupInfo;
import org.lwjgl.vulkan.VkRect2D;

public class VkBindImageMemoryDeviceGroupInfoKHR
extends VkBindImageMemoryDeviceGroupInfo {
    VkBindImageMemoryDeviceGroupInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkBindImageMemoryDeviceGroupInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBindImageMemoryDeviceGroupInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public VkBindImageMemoryDeviceGroupInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBindImageMemoryDeviceGroupInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBindImageMemoryDeviceGroupInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkBindImageMemoryDeviceGroupInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBindImageMemoryDeviceGroupInfoKHR pDeviceIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkBindImageMemoryDeviceGroupInfoKHR.npDeviceIndices(this.address(), value);
        return this;
    }

    @Override
    public VkBindImageMemoryDeviceGroupInfoKHR pSplitInstanceBindRegions(@Nullable @NativeType(value="VkRect2D const *") VkRect2D.Buffer value) {
        VkBindImageMemoryDeviceGroupInfoKHR.npSplitInstanceBindRegions(this.address(), value);
        return this;
    }

    @Override
    public VkBindImageMemoryDeviceGroupInfoKHR set(int sType, long pNext, @Nullable IntBuffer pDeviceIndices, @Nullable VkRect2D.Buffer pSplitInstanceBindRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.pDeviceIndices(pDeviceIndices);
        this.pSplitInstanceBindRegions(pSplitInstanceBindRegions);
        return this;
    }

    public VkBindImageMemoryDeviceGroupInfoKHR set(VkBindImageMemoryDeviceGroupInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindImageMemoryDeviceGroupInfoKHR malloc() {
        return VkBindImageMemoryDeviceGroupInfoKHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBindImageMemoryDeviceGroupInfoKHR calloc() {
        return VkBindImageMemoryDeviceGroupInfoKHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBindImageMemoryDeviceGroupInfoKHR create() {
        return new VkBindImageMemoryDeviceGroupInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBindImageMemoryDeviceGroupInfoKHR create(long address) {
        return new VkBindImageMemoryDeviceGroupInfoKHR(address, null);
    }

    @Nullable
    public static VkBindImageMemoryDeviceGroupInfoKHR createSafe(long address) {
        return address == 0L ? null : VkBindImageMemoryDeviceGroupInfoKHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkBindImageMemoryDeviceGroupInfoKHR.create(VkBindImageMemoryDeviceGroupInfoKHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBindImageMemoryDeviceGroupInfoKHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkBindImageMemoryDeviceGroupInfoKHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBindImageMemoryDeviceGroupInfoKHR.create(address, capacity);
    }

    public static VkBindImageMemoryDeviceGroupInfoKHR mallocStack() {
        return VkBindImageMemoryDeviceGroupInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkBindImageMemoryDeviceGroupInfoKHR callocStack() {
        return VkBindImageMemoryDeviceGroupInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkBindImageMemoryDeviceGroupInfoKHR mallocStack(MemoryStack stack) {
        return VkBindImageMemoryDeviceGroupInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindImageMemoryDeviceGroupInfoKHR callocStack(MemoryStack stack) {
        return VkBindImageMemoryDeviceGroupInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBindImageMemoryDeviceGroupInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBindImageMemoryDeviceGroupInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindImageMemoryDeviceGroupInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindImageMemoryDeviceGroupInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBindImageMemoryDeviceGroupInfo.Buffer {
        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBindImageMemoryDeviceGroupInfoKHR newInstance(long address) {
            return new VkBindImageMemoryDeviceGroupInfoKHR(address, this.container);
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindImageMemoryDeviceGroupInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindImageMemoryDeviceGroupInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer pDeviceIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkBindImageMemoryDeviceGroupInfoKHR.npDeviceIndices(this.address(), value);
            return this;
        }

        @Override
        public Buffer pSplitInstanceBindRegions(@Nullable @NativeType(value="VkRect2D const *") VkRect2D.Buffer value) {
            VkBindImageMemoryDeviceGroupInfoKHR.npSplitInstanceBindRegions(this.address(), value);
            return this;
        }
    }
}

