/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkAttachmentReference2KHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ATTACHMENT;
    public static final int LAYOUT;
    public static final int ASPECTMASK;

    VkAttachmentReference2KHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VkAttachmentReference2KHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkAttachmentReference2KHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkAttachmentReference2KHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkAttachmentReference2KHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachment() {
        return VkAttachmentReference2KHR.nattachment(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int layout() {
        return VkAttachmentReference2KHR.nlayout(this.address());
    }

    @NativeType(value="VkImageAspectFlags")
    public int aspectMask() {
        return VkAttachmentReference2KHR.naspectMask(this.address());
    }

    public VkAttachmentReference2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkAttachmentReference2KHR.nsType(this.address(), value);
        return this;
    }

    public VkAttachmentReference2KHR pNext(@NativeType(value="void const *") long value) {
        VkAttachmentReference2KHR.npNext(this.address(), value);
        return this;
    }

    public VkAttachmentReference2KHR attachment(@NativeType(value="uint32_t") int value) {
        VkAttachmentReference2KHR.nattachment(this.address(), value);
        return this;
    }

    public VkAttachmentReference2KHR layout(@NativeType(value="VkImageLayout") int value) {
        VkAttachmentReference2KHR.nlayout(this.address(), value);
        return this;
    }

    public VkAttachmentReference2KHR aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkAttachmentReference2KHR.naspectMask(this.address(), value);
        return this;
    }

    public VkAttachmentReference2KHR set(int sType, long pNext, int attachment, int layout, int aspectMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.attachment(attachment);
        this.layout(layout);
        this.aspectMask(aspectMask);
        return this;
    }

    public VkAttachmentReference2KHR set(VkAttachmentReference2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAttachmentReference2KHR malloc() {
        return VkAttachmentReference2KHR.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkAttachmentReference2KHR calloc() {
        return VkAttachmentReference2KHR.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkAttachmentReference2KHR create() {
        return new VkAttachmentReference2KHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkAttachmentReference2KHR create(long address) {
        return new VkAttachmentReference2KHR(address, null);
    }

    @Nullable
    public static VkAttachmentReference2KHR createSafe(long address) {
        return address == 0L ? null : VkAttachmentReference2KHR.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VkAttachmentReference2KHR.create(VkAttachmentReference2KHR.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAttachmentReference2KHR.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VkAttachmentReference2KHR.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkAttachmentReference2KHR.create(address, capacity);
    }

    public static VkAttachmentReference2KHR mallocStack() {
        return VkAttachmentReference2KHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentReference2KHR callocStack() {
        return VkAttachmentReference2KHR.callocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentReference2KHR mallocStack(MemoryStack stack) {
        return VkAttachmentReference2KHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAttachmentReference2KHR callocStack(MemoryStack stack) {
        return VkAttachmentReference2KHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkAttachmentReference2KHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkAttachmentReference2KHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAttachmentReference2KHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAttachmentReference2KHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nattachment(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ATTACHMENT);
    }

    public static int nlayout(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYOUT);
    }

    public static int naspectMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ASPECTMASK);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nattachment(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ATTACHMENT, value);
    }

    public static void nlayout(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LAYOUT, value);
    }

    public static void naspectMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ASPECTMASK, value);
    }

    static {
        Struct.Layout layout = VkAttachmentReference2KHR.__struct(VkAttachmentReference2KHR.__member(4), VkAttachmentReference2KHR.__member(POINTER_SIZE), VkAttachmentReference2KHR.__member(4), VkAttachmentReference2KHR.__member(4), VkAttachmentReference2KHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ATTACHMENT = layout.offsetof(2);
        LAYOUT = layout.offsetof(3);
        ASPECTMASK = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkAttachmentReference2KHR, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkAttachmentReference2KHR newInstance(long address) {
            return new VkAttachmentReference2KHR(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkAttachmentReference2KHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkAttachmentReference2KHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachment() {
            return VkAttachmentReference2KHR.nattachment(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int layout() {
            return VkAttachmentReference2KHR.nlayout(this.address());
        }

        @NativeType(value="VkImageAspectFlags")
        public int aspectMask() {
            return VkAttachmentReference2KHR.naspectMask(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAttachmentReference2KHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAttachmentReference2KHR.npNext(this.address(), value);
            return this;
        }

        public Buffer attachment(@NativeType(value="uint32_t") int value) {
            VkAttachmentReference2KHR.nattachment(this.address(), value);
            return this;
        }

        public Buffer layout(@NativeType(value="VkImageLayout") int value) {
            VkAttachmentReference2KHR.nlayout(this.address(), value);
            return this;
        }

        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkAttachmentReference2KHR.naspectMask(this.address(), value);
            return this;
        }
    }
}

