/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkSurfaceCapabilitiesKHR;
import org.lwjgl.vulkan.VkSurfaceFormatKHR;

public class KHRSurface {
    public static final int VK_KHR_SURFACE_SPEC_VERSION = 25;
    public static final String VK_KHR_SURFACE_EXTENSION_NAME = "VK_KHR_surface";
    public static final int VK_ERROR_SURFACE_LOST_KHR = -1000000000;
    public static final int VK_ERROR_NATIVE_WINDOW_IN_USE_KHR = -1000000001;
    public static final int VK_OBJECT_TYPE_SURFACE_KHR = 1000000000;
    public static final int VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR = 1;
    public static final int VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR = 2;
    public static final int VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR = 4;
    public static final int VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR = 8;
    public static final int VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR = 16;
    public static final int VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR = 32;
    public static final int VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR = 64;
    public static final int VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR = 128;
    public static final int VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR = 256;
    public static final int VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR = 1;
    public static final int VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR = 2;
    public static final int VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR = 4;
    public static final int VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR = 8;
    public static final int VK_COLOR_SPACE_SRGB_NONLINEAR_KHR = 0;
    public static final int VK_PRESENT_MODE_IMMEDIATE_KHR = 0;
    public static final int VK_PRESENT_MODE_MAILBOX_KHR = 1;
    public static final int VK_PRESENT_MODE_FIFO_KHR = 2;
    public static final int VK_PRESENT_MODE_FIFO_RELAXED_KHR = 3;

    protected KHRSurface() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsInstance(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_SURFACE_EXTENSION_NAME) && VK.checkExtension(VK_KHR_SURFACE_EXTENSION_NAME, VK.isSupported(provider, "vkDestroySurfaceKHR", caps) && VK.isSupported(provider, "vkGetPhysicalDeviceSurfaceSupportKHR", caps) && VK.isSupported(provider, "vkGetPhysicalDeviceSurfaceCapabilitiesKHR", caps) && VK.isSupported(provider, "vkGetPhysicalDeviceSurfaceFormatsKHR", caps) && VK.isSupported(provider, "vkGetPhysicalDeviceSurfacePresentModesKHR", caps));
    }

    public static void nvkDestroySurfaceKHR(VkInstance instance, long surface, long pAllocator) {
        long __functionAddress = instance.getCapabilities().vkDestroySurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        JNI.callPJPV(__functionAddress, instance.address(), surface, pAllocator);
    }

    public static void vkDestroySurfaceKHR(VkInstance instance, @NativeType(value="VkSurfaceKHR") long surface, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        KHRSurface.nvkDestroySurfaceKHR(instance, surface, MemoryUtil.memAddressSafe(pAllocator));
    }

    public static int nvkGetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, int queueFamilyIndex, long surface, long pSupported) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceSurfaceSupportKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(__functionAddress, physicalDevice.address(), queueFamilyIndex, surface, pSupported);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t") int queueFamilyIndex, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="VkBool32 *") IntBuffer pSupported) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSupported, 1);
        }
        return KHRSurface.nvkGetPhysicalDeviceSurfaceSupportKHR(physicalDevice, queueFamilyIndex, surface, MemoryUtil.memAddress(pSupported));
    }

    public static int nvkGetPhysicalDeviceSurfaceCapabilitiesKHR(VkPhysicalDevice physicalDevice, long surface, long pSurfaceCapabilities) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceSurfaceCapabilitiesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(__functionAddress, physicalDevice.address(), surface, pSurfaceCapabilities);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceSurfaceCapabilitiesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="VkSurfaceCapabilitiesKHR *") VkSurfaceCapabilitiesKHR pSurfaceCapabilities) {
        return KHRSurface.nvkGetPhysicalDeviceSurfaceCapabilitiesKHR(physicalDevice, surface, pSurfaceCapabilities.address());
    }

    public static int nvkGetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, long surface, long pSurfaceFormatCount, long pSurfaceFormats) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceSurfaceFormatsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(__functionAddress, physicalDevice.address(), surface, pSurfaceFormatCount, pSurfaceFormats);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="uint32_t *") IntBuffer pSurfaceFormatCount, @Nullable @NativeType(value="VkSurfaceFormatKHR *") VkSurfaceFormatKHR.Buffer pSurfaceFormats) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSurfaceFormatCount, 1);
            Checks.checkSafe(pSurfaceFormats, pSurfaceFormatCount.get(pSurfaceFormatCount.position()));
        }
        return KHRSurface.nvkGetPhysicalDeviceSurfaceFormatsKHR(physicalDevice, surface, MemoryUtil.memAddress(pSurfaceFormatCount), MemoryUtil.memAddressSafe(pSurfaceFormats));
    }

    public static int nvkGetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, long surface, long pPresentModeCount, long pPresentModes) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceSurfacePresentModesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(__functionAddress, physicalDevice.address(), surface, pPresentModeCount, pPresentModes);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="uint32_t *") IntBuffer pPresentModeCount, @Nullable @NativeType(value="VkPresentModeKHR *") IntBuffer pPresentModes) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPresentModeCount, 1);
            Checks.checkSafe((Buffer)pPresentModes, pPresentModeCount.get(pPresentModeCount.position()));
        }
        return KHRSurface.nvkGetPhysicalDeviceSurfacePresentModesKHR(physicalDevice, surface, MemoryUtil.memAddress(pPresentModeCount), MemoryUtil.memAddressSafe(pPresentModes));
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t") int queueFamilyIndex, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="VkBool32 *") int[] pSupported) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceSurfaceSupportKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pSupported, 1);
        }
        return JNI.callPJPI(__functionAddress, physicalDevice.address(), queueFamilyIndex, surface, pSupported);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="uint32_t *") int[] pSurfaceFormatCount, @Nullable @NativeType(value="VkSurfaceFormatKHR *") VkSurfaceFormatKHR.Buffer pSurfaceFormats) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceSurfaceFormatsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pSurfaceFormatCount, 1);
            Checks.checkSafe(pSurfaceFormats, pSurfaceFormatCount[0]);
        }
        return JNI.callPJPPI(__functionAddress, physicalDevice.address(), surface, pSurfaceFormatCount, MemoryUtil.memAddressSafe(pSurfaceFormats));
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="uint32_t *") int[] pPresentModeCount, @Nullable @NativeType(value="VkPresentModeKHR *") int[] pPresentModes) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceSurfacePresentModesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPresentModeCount, 1);
            Checks.checkSafe(pPresentModes, pPresentModeCount[0]);
        }
        return JNI.callPJPPI(__functionAddress, physicalDevice.address(), surface, pPresentModeCount, pPresentModes);
    }
}

