/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkDisplayModeProperties2KHR;
import org.lwjgl.vulkan.VkDisplayPlaneCapabilities2KHR;
import org.lwjgl.vulkan.VkDisplayPlaneInfo2KHR;
import org.lwjgl.vulkan.VkDisplayPlaneProperties2KHR;
import org.lwjgl.vulkan.VkDisplayProperties2KHR;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class KHRGetDisplayProperties2 {
    public static final int VK_KHR_GET_DISPLAY_PROPERTIES_2_SPEC_VERSION = 1;
    public static final String VK_KHR_GET_DISPLAY_PROPERTIES_2_EXTENSION_NAME = "VK_KHR_get_display_properties2";
    public static final int VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR = 1000121000;
    public static final int VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR = 1000121001;
    public static final int VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR = 1000121002;
    public static final int VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR = 1000121003;
    public static final int VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR = 1000121004;

    protected KHRGetDisplayProperties2() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsInstance(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_GET_DISPLAY_PROPERTIES_2_EXTENSION_NAME) && VK.checkExtension(VK_KHR_GET_DISPLAY_PROPERTIES_2_EXTENSION_NAME, VK.isSupported(provider, "vkGetPhysicalDeviceDisplayProperties2KHR", caps) && VK.isSupported(provider, "vkGetPhysicalDeviceDisplayPlaneProperties2KHR", caps) && VK.isSupported(provider, "vkGetDisplayModeProperties2KHR", caps) && VK.isSupported(provider, "vkGetDisplayPlaneCapabilities2KHR", caps));
    }

    public static int nvkGetPhysicalDeviceDisplayProperties2KHR(VkPhysicalDevice physicalDevice, long pPropertyCount, long pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceDisplayProperties2KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, physicalDevice.address(), pPropertyCount, pProperties);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceDisplayProperties2KHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") IntBuffer pPropertyCount, @Nullable @NativeType(value="VkDisplayProperties2KHR *") VkDisplayProperties2KHR.Buffer pProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPropertyCount, 1);
            Checks.checkSafe(pProperties, pPropertyCount.get(pPropertyCount.position()));
        }
        return KHRGetDisplayProperties2.nvkGetPhysicalDeviceDisplayProperties2KHR(physicalDevice, MemoryUtil.memAddress(pPropertyCount), MemoryUtil.memAddressSafe(pProperties));
    }

    public static int nvkGetPhysicalDeviceDisplayPlaneProperties2KHR(VkPhysicalDevice physicalDevice, long pPropertyCount, long pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceDisplayPlaneProperties2KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, physicalDevice.address(), pPropertyCount, pProperties);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceDisplayPlaneProperties2KHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") IntBuffer pPropertyCount, @Nullable @NativeType(value="VkDisplayPlaneProperties2KHR *") VkDisplayPlaneProperties2KHR.Buffer pProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPropertyCount, 1);
            Checks.checkSafe(pProperties, pPropertyCount.get(pPropertyCount.position()));
        }
        return KHRGetDisplayProperties2.nvkGetPhysicalDeviceDisplayPlaneProperties2KHR(physicalDevice, MemoryUtil.memAddress(pPropertyCount), MemoryUtil.memAddressSafe(pProperties));
    }

    public static int nvkGetDisplayModeProperties2KHR(VkPhysicalDevice physicalDevice, long display, long pPropertyCount, long pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetDisplayModeProperties2KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(__functionAddress, physicalDevice.address(), display, pPropertyCount, pProperties);
    }

    @NativeType(value="VkResult")
    public static int vkGetDisplayModeProperties2KHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkDisplayKHR") long display, @NativeType(value="uint32_t *") IntBuffer pPropertyCount, @Nullable @NativeType(value="VkDisplayModeProperties2KHR *") VkDisplayModeProperties2KHR.Buffer pProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPropertyCount, 1);
            Checks.checkSafe(pProperties, pPropertyCount.get(pPropertyCount.position()));
        }
        return KHRGetDisplayProperties2.nvkGetDisplayModeProperties2KHR(physicalDevice, display, MemoryUtil.memAddress(pPropertyCount), MemoryUtil.memAddressSafe(pProperties));
    }

    public static int nvkGetDisplayPlaneCapabilities2KHR(VkPhysicalDevice physicalDevice, long pDisplayPlaneInfo, long pCapabilities) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetDisplayPlaneCapabilities2KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, physicalDevice.address(), pDisplayPlaneInfo, pCapabilities);
    }

    @NativeType(value="VkResult")
    public static int vkGetDisplayPlaneCapabilities2KHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkDisplayPlaneInfo2KHR const *") VkDisplayPlaneInfo2KHR pDisplayPlaneInfo, @NativeType(value="VkDisplayPlaneCapabilities2KHR *") VkDisplayPlaneCapabilities2KHR pCapabilities) {
        return KHRGetDisplayProperties2.nvkGetDisplayPlaneCapabilities2KHR(physicalDevice, pDisplayPlaneInfo.address(), pCapabilities.address());
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceDisplayProperties2KHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") int[] pPropertyCount, @Nullable @NativeType(value="VkDisplayProperties2KHR *") VkDisplayProperties2KHR.Buffer pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceDisplayProperties2KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPropertyCount, 1);
            Checks.checkSafe(pProperties, pPropertyCount[0]);
        }
        return JNI.callPPPI(__functionAddress, physicalDevice.address(), pPropertyCount, MemoryUtil.memAddressSafe(pProperties));
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceDisplayPlaneProperties2KHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") int[] pPropertyCount, @Nullable @NativeType(value="VkDisplayPlaneProperties2KHR *") VkDisplayPlaneProperties2KHR.Buffer pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceDisplayPlaneProperties2KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPropertyCount, 1);
            Checks.checkSafe(pProperties, pPropertyCount[0]);
        }
        return JNI.callPPPI(__functionAddress, physicalDevice.address(), pPropertyCount, MemoryUtil.memAddressSafe(pProperties));
    }

    @NativeType(value="VkResult")
    public static int vkGetDisplayModeProperties2KHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkDisplayKHR") long display, @NativeType(value="uint32_t *") int[] pPropertyCount, @Nullable @NativeType(value="VkDisplayModeProperties2KHR *") VkDisplayModeProperties2KHR.Buffer pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetDisplayModeProperties2KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPropertyCount, 1);
            Checks.checkSafe(pProperties, pPropertyCount[0]);
        }
        return JNI.callPJPPI(__functionAddress, physicalDevice.address(), display, pPropertyCount, MemoryUtil.memAddressSafe(pProperties));
    }
}

