/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkPastPresentationTimingGOOGLE;
import org.lwjgl.vulkan.VkRefreshCycleDurationGOOGLE;

public class GOOGLEDisplayTiming {
    public static final int VK_GOOGLE_DISPLAY_TIMING_SPEC_VERSION = 1;
    public static final String VK_GOOGLE_DISPLAY_TIMING_EXTENSION_NAME = "VK_GOOGLE_display_timing";
    public static final int VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE = 1000092000;

    protected GOOGLEDisplayTiming() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_GOOGLE_DISPLAY_TIMING_EXTENSION_NAME) && VK.checkExtension(VK_GOOGLE_DISPLAY_TIMING_EXTENSION_NAME, VK.isSupported(provider, "vkGetRefreshCycleDurationGOOGLE", caps) && VK.isSupported(provider, "vkGetPastPresentationTimingGOOGLE", caps));
    }

    public static int nvkGetRefreshCycleDurationGOOGLE(VkDevice device, long swapchain, long pDisplayTimingProperties) {
        long __functionAddress = device.getCapabilities().vkGetRefreshCycleDurationGOOGLE;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(__functionAddress, device.address(), swapchain, pDisplayTimingProperties);
    }

    @NativeType(value="VkResult")
    public static int vkGetRefreshCycleDurationGOOGLE(VkDevice device, @NativeType(value="VkSwapchainKHR") long swapchain, @NativeType(value="VkRefreshCycleDurationGOOGLE *") VkRefreshCycleDurationGOOGLE pDisplayTimingProperties) {
        return GOOGLEDisplayTiming.nvkGetRefreshCycleDurationGOOGLE(device, swapchain, pDisplayTimingProperties.address());
    }

    public static int nvkGetPastPresentationTimingGOOGLE(VkDevice device, long swapchain, long pPresentationTimingCount, long pPresentationTimings) {
        long __functionAddress = device.getCapabilities().vkGetPastPresentationTimingGOOGLE;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(__functionAddress, device.address(), swapchain, pPresentationTimingCount, pPresentationTimings);
    }

    @NativeType(value="VkResult")
    public static int vkGetPastPresentationTimingGOOGLE(VkDevice device, @NativeType(value="VkSwapchainKHR") long swapchain, @NativeType(value="uint32_t *") IntBuffer pPresentationTimingCount, @Nullable @NativeType(value="VkPastPresentationTimingGOOGLE *") VkPastPresentationTimingGOOGLE.Buffer pPresentationTimings) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPresentationTimingCount, 1);
            Checks.checkSafe(pPresentationTimings, pPresentationTimingCount.get(pPresentationTimingCount.position()));
        }
        return GOOGLEDisplayTiming.nvkGetPastPresentationTimingGOOGLE(device, swapchain, MemoryUtil.memAddress(pPresentationTimingCount), MemoryUtil.memAddressSafe(pPresentationTimings));
    }

    @NativeType(value="VkResult")
    public static int vkGetPastPresentationTimingGOOGLE(VkDevice device, @NativeType(value="VkSwapchainKHR") long swapchain, @NativeType(value="uint32_t *") int[] pPresentationTimingCount, @Nullable @NativeType(value="VkPastPresentationTimingGOOGLE *") VkPastPresentationTimingGOOGLE.Buffer pPresentationTimings) {
        long __functionAddress = device.getCapabilities().vkGetPastPresentationTimingGOOGLE;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPresentationTimingCount, 1);
            Checks.checkSafe(pPresentationTimings, pPresentationTimingCount[0]);
        }
        return JNI.callPJPPI(__functionAddress, device.address(), swapchain, pPresentationTimingCount, MemoryUtil.memAddressSafe(pPresentationTimings));
    }
}

