/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.util.Map;
import java.util.Set;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkConditionalRenderingBeginInfoEXT;

public class EXTConditionalRendering {
    public static final int VK_EXT_CONDITIONAL_RENDERING_SPEC_VERSION = 1;
    public static final String VK_EXT_CONDITIONAL_RENDERING_EXTENSION_NAME = "VK_EXT_conditional_rendering";
    public static final int VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT = 1000081000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT = 1000081001;
    public static final int VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT = 1000081002;
    public static final int VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT = 0x100000;
    public static final int VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT = 512;
    public static final int VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT = 262144;
    public static final int VK_CONDITIONAL_RENDERING_INVERTED_BIT_EXT = 1;

    protected EXTConditionalRendering() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_EXT_CONDITIONAL_RENDERING_EXTENSION_NAME) && VK.checkExtension(VK_EXT_CONDITIONAL_RENDERING_EXTENSION_NAME, VK.isSupported(provider, "vkCmdBeginConditionalRenderingEXT", caps) && VK.isSupported(provider, "vkCmdEndConditionalRenderingEXT", caps));
    }

    public static void nvkCmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, long pConditionalRenderingBegin) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBeginConditionalRenderingEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, commandBuffer.address(), pConditionalRenderingBegin);
    }

    public static void vkCmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkConditionalRenderingBeginInfoEXT const *") VkConditionalRenderingBeginInfoEXT pConditionalRenderingBegin) {
        EXTConditionalRendering.nvkCmdBeginConditionalRenderingEXT(commandBuffer, pConditionalRenderingBegin.address());
    }

    public static void vkCmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdEndConditionalRenderingEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, commandBuffer.address());
    }
}

