/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.util.Map;
import java.util.Set;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkCommandBuffer;

public class AMDDrawIndirectCount {
    public static final int VK_AMD_DRAW_INDIRECT_COUNT_SPEC_VERSION = 1;
    public static final String VK_AMD_DRAW_INDIRECT_COUNT_EXTENSION_NAME = "VK_AMD_draw_indirect_count";

    protected AMDDrawIndirectCount() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_AMD_DRAW_INDIRECT_COUNT_EXTENSION_NAME) && VK.checkExtension(VK_AMD_DRAW_INDIRECT_COUNT_EXTENSION_NAME, VK.isSupported(provider, "vkCmdDrawIndirectCountAMD", caps) && VK.isSupported(provider, "vkCmdDrawIndexedIndirectCountAMD", caps));
    }

    public static void vkCmdDrawIndirectCountAMD(VkCommandBuffer commandBuffer, @NativeType(value="VkBuffer") long buffer, @NativeType(value="VkDeviceSize") long offset, @NativeType(value="VkBuffer") long countBuffer, @NativeType(value="VkDeviceSize") long countBufferOffset, @NativeType(value="uint32_t") int maxDrawCount, @NativeType(value="uint32_t") int stride) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDrawIndirectCountAMD;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPJJJJV(__functionAddress, commandBuffer.address(), buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    }

    public static void vkCmdDrawIndexedIndirectCountAMD(VkCommandBuffer commandBuffer, @NativeType(value="VkBuffer") long buffer, @NativeType(value="VkDeviceSize") long offset, @NativeType(value="VkBuffer") long countBuffer, @NativeType(value="VkDeviceSize") long countBufferOffset, @NativeType(value="uint32_t") int maxDrawCount, @NativeType(value="uint32_t") int stride) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDrawIndexedIndirectCountAMD;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPJJJJV(__functionAddress, commandBuffer.address(), buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    }
}

