/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.zstd.ZSTDAllocFunction;
import org.lwjgl.util.zstd.ZSTDAllocFunctionI;
import org.lwjgl.util.zstd.ZSTDFreeFunction;
import org.lwjgl.util.zstd.ZSTDFreeFunctionI;

@NativeType(value="struct ZSTD_customMem")
public class ZSTDCustomMem
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CUSTOMALLOC;
    public static final int CUSTOMFREE;
    public static final int OPAQUE;

    ZSTDCustomMem(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public ZSTDCustomMem(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), ZSTDCustomMem.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ZSTD_allocFunction")
    public ZSTDAllocFunction customAlloc() {
        return ZSTDCustomMem.ncustomAlloc(this.address());
    }

    @NativeType(value="ZSTD_freeFunction")
    public ZSTDFreeFunction customFree() {
        return ZSTDCustomMem.ncustomFree(this.address());
    }

    @NativeType(value="void *")
    public long opaque() {
        return ZSTDCustomMem.nopaque(this.address());
    }

    public ZSTDCustomMem customAlloc(@NativeType(value="ZSTD_allocFunction") ZSTDAllocFunctionI value) {
        ZSTDCustomMem.ncustomAlloc(this.address(), value);
        return this;
    }

    public ZSTDCustomMem customFree(@NativeType(value="ZSTD_freeFunction") ZSTDFreeFunctionI value) {
        ZSTDCustomMem.ncustomFree(this.address(), value);
        return this;
    }

    public ZSTDCustomMem opaque(@NativeType(value="void *") long value) {
        ZSTDCustomMem.nopaque(this.address(), value);
        return this;
    }

    public ZSTDCustomMem set(ZSTDAllocFunctionI customAlloc, ZSTDFreeFunctionI customFree, long opaque) {
        this.customAlloc(customAlloc);
        this.customFree(customFree);
        this.opaque(opaque);
        return this;
    }

    public ZSTDCustomMem set(ZSTDCustomMem src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ZSTDCustomMem malloc() {
        return ZSTDCustomMem.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static ZSTDCustomMem calloc() {
        return ZSTDCustomMem.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static ZSTDCustomMem create() {
        return new ZSTDCustomMem(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static ZSTDCustomMem create(long address) {
        return new ZSTDCustomMem(address, null);
    }

    @Nullable
    public static ZSTDCustomMem createSafe(long address) {
        return address == 0L ? null : ZSTDCustomMem.create(address);
    }

    public static Buffer malloc(int capacity) {
        return ZSTDCustomMem.create(ZSTDCustomMem.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ZSTDCustomMem.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(ZSTDCustomMem.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ZSTDCustomMem.create(address, capacity);
    }

    public static ZSTDCustomMem mallocStack() {
        return ZSTDCustomMem.mallocStack(MemoryStack.stackGet());
    }

    public static ZSTDCustomMem callocStack() {
        return ZSTDCustomMem.callocStack(MemoryStack.stackGet());
    }

    public static ZSTDCustomMem mallocStack(MemoryStack stack) {
        return ZSTDCustomMem.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDCustomMem callocStack(MemoryStack stack) {
        return ZSTDCustomMem.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ZSTDCustomMem.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ZSTDCustomMem.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDCustomMem.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDCustomMem.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ZSTDAllocFunction ncustomAlloc(long struct) {
        return ZSTDAllocFunction.create(MemoryUtil.memGetAddress(struct + (long)CUSTOMALLOC));
    }

    public static ZSTDFreeFunction ncustomFree(long struct) {
        return ZSTDFreeFunction.create(MemoryUtil.memGetAddress(struct + (long)CUSTOMFREE));
    }

    public static long nopaque(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)OPAQUE);
    }

    public static void ncustomAlloc(long struct, ZSTDAllocFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)CUSTOMALLOC, value.address());
    }

    public static void ncustomFree(long struct, ZSTDFreeFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)CUSTOMFREE, value.address());
    }

    public static void nopaque(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)OPAQUE, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CUSTOMALLOC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CUSTOMFREE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)OPAQUE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            ZSTDCustomMem.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = ZSTDCustomMem.__struct(ZSTDCustomMem.__member(POINTER_SIZE), ZSTDCustomMem.__member(POINTER_SIZE), ZSTDCustomMem.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CUSTOMALLOC = layout.offsetof(0);
        CUSTOMFREE = layout.offsetof(1);
        OPAQUE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZSTDCustomMem, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected ZSTDCustomMem newInstance(long address) {
            return new ZSTDCustomMem(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ZSTD_allocFunction")
        public ZSTDAllocFunction customAlloc() {
            return ZSTDCustomMem.ncustomAlloc(this.address());
        }

        @NativeType(value="ZSTD_freeFunction")
        public ZSTDFreeFunction customFree() {
            return ZSTDCustomMem.ncustomFree(this.address());
        }

        @NativeType(value="void *")
        public long opaque() {
            return ZSTDCustomMem.nopaque(this.address());
        }

        public Buffer customAlloc(@NativeType(value="ZSTD_allocFunction") ZSTDAllocFunctionI value) {
            ZSTDCustomMem.ncustomAlloc(this.address(), value);
            return this;
        }

        public Buffer customFree(@NativeType(value="ZSTD_freeFunction") ZSTDFreeFunctionI value) {
            ZSTDCustomMem.ncustomFree(this.address(), value);
            return this;
        }

        public Buffer opaque(@NativeType(value="void *") long value) {
            ZSTDCustomMem.nopaque(this.address(), value);
            return this;
        }
    }
}

