/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZDICT_params_t")
public class ZDICTParams
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COMPRESSIONLEVEL;
    public static final int NOTIFICATIONLEVEL;
    public static final int DICTID;

    ZDICTParams(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public ZDICTParams(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), ZDICTParams.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int compressionLevel() {
        return ZDICTParams.ncompressionLevel(this.address());
    }

    @NativeType(value="unsigned")
    public int notificationLevel() {
        return ZDICTParams.nnotificationLevel(this.address());
    }

    @NativeType(value="unsigned")
    public int dictID() {
        return ZDICTParams.ndictID(this.address());
    }

    public ZDICTParams compressionLevel(int value) {
        ZDICTParams.ncompressionLevel(this.address(), value);
        return this;
    }

    public ZDICTParams notificationLevel(@NativeType(value="unsigned") int value) {
        ZDICTParams.nnotificationLevel(this.address(), value);
        return this;
    }

    public ZDICTParams dictID(@NativeType(value="unsigned") int value) {
        ZDICTParams.ndictID(this.address(), value);
        return this;
    }

    public ZDICTParams set(int compressionLevel, int notificationLevel, int dictID) {
        this.compressionLevel(compressionLevel);
        this.notificationLevel(notificationLevel);
        this.dictID(dictID);
        return this;
    }

    public ZDICTParams set(ZDICTParams src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ZDICTParams malloc() {
        return ZDICTParams.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static ZDICTParams calloc() {
        return ZDICTParams.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static ZDICTParams create() {
        return new ZDICTParams(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static ZDICTParams create(long address) {
        return new ZDICTParams(address, null);
    }

    @Nullable
    public static ZDICTParams createSafe(long address) {
        return address == 0L ? null : ZDICTParams.create(address);
    }

    public static Buffer malloc(int capacity) {
        return ZDICTParams.create(ZDICTParams.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ZDICTParams.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(ZDICTParams.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ZDICTParams.create(address, capacity);
    }

    public static ZDICTParams mallocStack() {
        return ZDICTParams.mallocStack(MemoryStack.stackGet());
    }

    public static ZDICTParams callocStack() {
        return ZDICTParams.callocStack(MemoryStack.stackGet());
    }

    public static ZDICTParams mallocStack(MemoryStack stack) {
        return ZDICTParams.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZDICTParams callocStack(MemoryStack stack) {
        return ZDICTParams.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ZDICTParams.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ZDICTParams.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZDICTParams.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZDICTParams.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ncompressionLevel(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPRESSIONLEVEL);
    }

    public static int nnotificationLevel(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NOTIFICATIONLEVEL);
    }

    public static int ndictID(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DICTID);
    }

    public static void ncompressionLevel(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COMPRESSIONLEVEL, value);
    }

    public static void nnotificationLevel(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NOTIFICATIONLEVEL, value);
    }

    public static void ndictID(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DICTID, value);
    }

    static {
        Struct.Layout layout = ZDICTParams.__struct(ZDICTParams.__member(4), ZDICTParams.__member(4), ZDICTParams.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COMPRESSIONLEVEL = layout.offsetof(0);
        NOTIFICATIONLEVEL = layout.offsetof(1);
        DICTID = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZDICTParams, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected ZDICTParams newInstance(long address) {
            return new ZDICTParams(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public int compressionLevel() {
            return ZDICTParams.ncompressionLevel(this.address());
        }

        @NativeType(value="unsigned")
        public int notificationLevel() {
            return ZDICTParams.nnotificationLevel(this.address());
        }

        @NativeType(value="unsigned")
        public int dictID() {
            return ZDICTParams.ndictID(this.address());
        }

        public Buffer compressionLevel(int value) {
            ZDICTParams.ncompressionLevel(this.address(), value);
            return this;
        }

        public Buffer notificationLevel(@NativeType(value="unsigned") int value) {
            ZDICTParams.nnotificationLevel(this.address(), value);
            return this;
        }

        public Buffer dictID(@NativeType(value="unsigned") int value) {
            ZDICTParams.ndictID(this.address(), value);
            return this;
        }
    }
}

