/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class YGValue
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VALUE;
    public static final int UNIT;

    YGValue(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public YGValue(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), YGValue.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float value() {
        return YGValue.nvalue(this.address());
    }

    @NativeType(value="YGUnit")
    public int unit() {
        return YGValue.nunit(this.address());
    }

    public YGValue value(float value) {
        YGValue.nvalue(this.address(), value);
        return this;
    }

    public YGValue unit(@NativeType(value="YGUnit") int value) {
        YGValue.nunit(this.address(), value);
        return this;
    }

    public YGValue set(float value, int unit) {
        this.value(value);
        this.unit(unit);
        return this;
    }

    public YGValue set(YGValue src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static YGValue malloc() {
        return YGValue.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static YGValue calloc() {
        return YGValue.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static YGValue create() {
        return new YGValue(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static YGValue create(long address) {
        return new YGValue(address, null);
    }

    @Nullable
    public static YGValue createSafe(long address) {
        return address == 0L ? null : YGValue.create(address);
    }

    public static Buffer malloc(int capacity) {
        return YGValue.create(YGValue.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return YGValue.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(YGValue.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : YGValue.create(address, capacity);
    }

    public static YGValue mallocStack() {
        return YGValue.mallocStack(MemoryStack.stackGet());
    }

    public static YGValue callocStack() {
        return YGValue.callocStack(MemoryStack.stackGet());
    }

    public static YGValue mallocStack(MemoryStack stack) {
        return YGValue.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static YGValue callocStack(MemoryStack stack) {
        return YGValue.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return YGValue.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return YGValue.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return YGValue.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return YGValue.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nvalue(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)VALUE);
    }

    public static int nunit(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNIT);
    }

    public static void nvalue(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)VALUE, value);
    }

    public static void nunit(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UNIT, value);
    }

    static {
        Struct.Layout layout = YGValue.__struct(YGValue.__member(4), YGValue.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VALUE = layout.offsetof(0);
        UNIT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<YGValue, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected YGValue newInstance(long address) {
            return new YGValue(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float value() {
            return YGValue.nvalue(this.address());
        }

        @NativeType(value="YGUnit")
        public int unit() {
            return YGValue.nunit(this.address());
        }

        public Buffer value(float value) {
            YGValue.nvalue(this.address(), value);
            return this;
        }

        public Buffer unit(@NativeType(value="YGUnit") int value) {
            YGValue.nunit(this.address(), value);
            return this;
        }
    }
}

