/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.yoga.YGFloatOptional;
import org.lwjgl.util.yoga.YGValue;

public class YGStyle
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DIRECTION;
    public static final int FLEXDIRECTION;
    public static final int JUSTIFYCONTENT;
    public static final int ALIGNCONTENT;
    public static final int ALIGNITEMS;
    public static final int ALIGNSELF;
    public static final int POSITIONTYPE;
    public static final int FLEXWRAP;
    public static final int OVERFLOW;
    public static final int DISPLAY;
    public static final int FLEX;
    public static final int FLEXGROW;
    public static final int FLEXSHRINK;
    public static final int FLEXBASIS;
    public static final int MARGIN;
    public static final int POSITIONS;
    public static final int PADDING;
    public static final int BORDER;
    public static final int DIMENSIONS;
    public static final int MINDIMENSIONS;
    public static final int MAXDIMENSIONS;
    public static final int ASPECTRATIO;

    YGStyle(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public YGStyle(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), YGStyle.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="YGDirection")
    public int direction() {
        return YGStyle.ndirection(this.address());
    }

    @NativeType(value="YGFlexDirection")
    public int flexDirection() {
        return YGStyle.nflexDirection(this.address());
    }

    @NativeType(value="YGJustify")
    public int justifyContent() {
        return YGStyle.njustifyContent(this.address());
    }

    @NativeType(value="YGAlign")
    public int alignContent() {
        return YGStyle.nalignContent(this.address());
    }

    @NativeType(value="YGAlign")
    public int alignItems() {
        return YGStyle.nalignItems(this.address());
    }

    @NativeType(value="YGAlign")
    public int alignSelf() {
        return YGStyle.nalignSelf(this.address());
    }

    @NativeType(value="YGPositionType")
    public int positionType() {
        return YGStyle.npositionType(this.address());
    }

    @NativeType(value="YGWrap")
    public int flexWrap() {
        return YGStyle.nflexWrap(this.address());
    }

    @NativeType(value="YGOverflow")
    public int overflow() {
        return YGStyle.noverflow(this.address());
    }

    @NativeType(value="YGDisplay")
    public int display() {
        return YGStyle.ndisplay(this.address());
    }

    public YGFloatOptional flex() {
        return YGStyle.nflex(this.address());
    }

    public YGFloatOptional flexGrow() {
        return YGStyle.nflexGrow(this.address());
    }

    public YGFloatOptional flexShrink() {
        return YGStyle.nflexShrink(this.address());
    }

    public YGValue flexBasis() {
        return YGStyle.nflexBasis(this.address());
    }

    public YGStyle flexBasis(Consumer<YGValue> consumer) {
        consumer.accept(this.flexBasis());
        return this;
    }

    @NativeType(value="YGValue[9]")
    public YGValue.Buffer margin() {
        return YGStyle.nmargin(this.address());
    }

    public YGValue margin(int index) {
        return YGStyle.nmargin(this.address(), index);
    }

    @NativeType(value="YGValue[9]")
    public YGValue.Buffer positions() {
        return YGStyle.npositions(this.address());
    }

    public YGValue positions(int index) {
        return YGStyle.npositions(this.address(), index);
    }

    @NativeType(value="YGValue[9]")
    public YGValue.Buffer padding() {
        return YGStyle.npadding(this.address());
    }

    public YGValue padding(int index) {
        return YGStyle.npadding(this.address(), index);
    }

    @NativeType(value="YGValue[9]")
    public YGValue.Buffer border() {
        return YGStyle.nborder(this.address());
    }

    public YGValue border(int index) {
        return YGStyle.nborder(this.address(), index);
    }

    @NativeType(value="YGValue[2]")
    public YGValue.Buffer dimensions() {
        return YGStyle.ndimensions(this.address());
    }

    public YGValue dimensions(int index) {
        return YGStyle.ndimensions(this.address(), index);
    }

    @NativeType(value="YGValue[2]")
    public YGValue.Buffer minDimensions() {
        return YGStyle.nminDimensions(this.address());
    }

    public YGValue minDimensions(int index) {
        return YGStyle.nminDimensions(this.address(), index);
    }

    @NativeType(value="YGValue[2]")
    public YGValue.Buffer maxDimensions() {
        return YGStyle.nmaxDimensions(this.address());
    }

    public YGValue maxDimensions(int index) {
        return YGStyle.nmaxDimensions(this.address(), index);
    }

    public YGFloatOptional aspectRatio() {
        return YGStyle.naspectRatio(this.address());
    }

    public static YGStyle create(long address) {
        return new YGStyle(address, null);
    }

    @Nullable
    public static YGStyle createSafe(long address) {
        return address == 0L ? null : YGStyle.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : YGStyle.create(address, capacity);
    }

    public static int ndirection(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DIRECTION);
    }

    public static int nflexDirection(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLEXDIRECTION);
    }

    public static int njustifyContent(long struct) {
        return MemoryUtil.memGetInt(struct + (long)JUSTIFYCONTENT);
    }

    public static int nalignContent(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ALIGNCONTENT);
    }

    public static int nalignItems(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ALIGNITEMS);
    }

    public static int nalignSelf(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ALIGNSELF);
    }

    public static int npositionType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)POSITIONTYPE);
    }

    public static int nflexWrap(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLEXWRAP);
    }

    public static int noverflow(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OVERFLOW);
    }

    public static int ndisplay(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DISPLAY);
    }

    public static YGFloatOptional nflex(long struct) {
        return YGFloatOptional.create(struct + (long)FLEX);
    }

    public static YGFloatOptional nflexGrow(long struct) {
        return YGFloatOptional.create(struct + (long)FLEXGROW);
    }

    public static YGFloatOptional nflexShrink(long struct) {
        return YGFloatOptional.create(struct + (long)FLEXSHRINK);
    }

    public static YGValue nflexBasis(long struct) {
        return YGValue.create(struct + (long)FLEXBASIS);
    }

    public static YGValue.Buffer nmargin(long struct) {
        return YGValue.create(struct + (long)MARGIN, 9);
    }

    public static YGValue nmargin(long struct, int index) {
        return YGValue.create(struct + (long)MARGIN + Checks.check(index, 9) * (long)YGValue.SIZEOF);
    }

    public static YGValue.Buffer npositions(long struct) {
        return YGValue.create(struct + (long)POSITIONS, 9);
    }

    public static YGValue npositions(long struct, int index) {
        return YGValue.create(struct + (long)POSITIONS + Checks.check(index, 9) * (long)YGValue.SIZEOF);
    }

    public static YGValue.Buffer npadding(long struct) {
        return YGValue.create(struct + (long)PADDING, 9);
    }

    public static YGValue npadding(long struct, int index) {
        return YGValue.create(struct + (long)PADDING + Checks.check(index, 9) * (long)YGValue.SIZEOF);
    }

    public static YGValue.Buffer nborder(long struct) {
        return YGValue.create(struct + (long)BORDER, 9);
    }

    public static YGValue nborder(long struct, int index) {
        return YGValue.create(struct + (long)BORDER + Checks.check(index, 9) * (long)YGValue.SIZEOF);
    }

    public static YGValue.Buffer ndimensions(long struct) {
        return YGValue.create(struct + (long)DIMENSIONS, 2);
    }

    public static YGValue ndimensions(long struct, int index) {
        return YGValue.create(struct + (long)DIMENSIONS + Checks.check(index, 2) * (long)YGValue.SIZEOF);
    }

    public static YGValue.Buffer nminDimensions(long struct) {
        return YGValue.create(struct + (long)MINDIMENSIONS, 2);
    }

    public static YGValue nminDimensions(long struct, int index) {
        return YGValue.create(struct + (long)MINDIMENSIONS + Checks.check(index, 2) * (long)YGValue.SIZEOF);
    }

    public static YGValue.Buffer nmaxDimensions(long struct) {
        return YGValue.create(struct + (long)MAXDIMENSIONS, 2);
    }

    public static YGValue nmaxDimensions(long struct, int index) {
        return YGValue.create(struct + (long)MAXDIMENSIONS + Checks.check(index, 2) * (long)YGValue.SIZEOF);
    }

    public static YGFloatOptional naspectRatio(long struct) {
        return YGFloatOptional.create(struct + (long)ASPECTRATIO);
    }

    static {
        Struct.Layout layout = YGStyle.__struct(YGStyle.__member(4), YGStyle.__member(4), YGStyle.__member(4), YGStyle.__member(4), YGStyle.__member(4), YGStyle.__member(4), YGStyle.__member(4), YGStyle.__member(4), YGStyle.__member(4), YGStyle.__member(4), YGStyle.__member(YGFloatOptional.SIZEOF, YGFloatOptional.ALIGNOF), YGStyle.__member(YGFloatOptional.SIZEOF, YGFloatOptional.ALIGNOF), YGStyle.__member(YGFloatOptional.SIZEOF, YGFloatOptional.ALIGNOF), YGStyle.__member(YGValue.SIZEOF, YGValue.ALIGNOF), YGStyle.__array(YGValue.SIZEOF, YGValue.ALIGNOF, 9), YGStyle.__array(YGValue.SIZEOF, YGValue.ALIGNOF, 9), YGStyle.__array(YGValue.SIZEOF, YGValue.ALIGNOF, 9), YGStyle.__array(YGValue.SIZEOF, YGValue.ALIGNOF, 9), YGStyle.__array(YGValue.SIZEOF, YGValue.ALIGNOF, 2), YGStyle.__array(YGValue.SIZEOF, YGValue.ALIGNOF, 2), YGStyle.__array(YGValue.SIZEOF, YGValue.ALIGNOF, 2), YGStyle.__member(YGFloatOptional.SIZEOF, YGFloatOptional.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DIRECTION = layout.offsetof(0);
        FLEXDIRECTION = layout.offsetof(1);
        JUSTIFYCONTENT = layout.offsetof(2);
        ALIGNCONTENT = layout.offsetof(3);
        ALIGNITEMS = layout.offsetof(4);
        ALIGNSELF = layout.offsetof(5);
        POSITIONTYPE = layout.offsetof(6);
        FLEXWRAP = layout.offsetof(7);
        OVERFLOW = layout.offsetof(8);
        DISPLAY = layout.offsetof(9);
        FLEX = layout.offsetof(10);
        FLEXGROW = layout.offsetof(11);
        FLEXSHRINK = layout.offsetof(12);
        FLEXBASIS = layout.offsetof(13);
        MARGIN = layout.offsetof(14);
        POSITIONS = layout.offsetof(15);
        PADDING = layout.offsetof(16);
        BORDER = layout.offsetof(17);
        DIMENSIONS = layout.offsetof(18);
        MINDIMENSIONS = layout.offsetof(19);
        MAXDIMENSIONS = layout.offsetof(20);
        ASPECTRATIO = layout.offsetof(21);
    }

    public static class Buffer
    extends StructBuffer<YGStyle, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected YGStyle newInstance(long address) {
            return new YGStyle(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="YGDirection")
        public int direction() {
            return YGStyle.ndirection(this.address());
        }

        @NativeType(value="YGFlexDirection")
        public int flexDirection() {
            return YGStyle.nflexDirection(this.address());
        }

        @NativeType(value="YGJustify")
        public int justifyContent() {
            return YGStyle.njustifyContent(this.address());
        }

        @NativeType(value="YGAlign")
        public int alignContent() {
            return YGStyle.nalignContent(this.address());
        }

        @NativeType(value="YGAlign")
        public int alignItems() {
            return YGStyle.nalignItems(this.address());
        }

        @NativeType(value="YGAlign")
        public int alignSelf() {
            return YGStyle.nalignSelf(this.address());
        }

        @NativeType(value="YGPositionType")
        public int positionType() {
            return YGStyle.npositionType(this.address());
        }

        @NativeType(value="YGWrap")
        public int flexWrap() {
            return YGStyle.nflexWrap(this.address());
        }

        @NativeType(value="YGOverflow")
        public int overflow() {
            return YGStyle.noverflow(this.address());
        }

        @NativeType(value="YGDisplay")
        public int display() {
            return YGStyle.ndisplay(this.address());
        }

        public YGFloatOptional flex() {
            return YGStyle.nflex(this.address());
        }

        public YGFloatOptional flexGrow() {
            return YGStyle.nflexGrow(this.address());
        }

        public YGFloatOptional flexShrink() {
            return YGStyle.nflexShrink(this.address());
        }

        public YGValue flexBasis() {
            return YGStyle.nflexBasis(this.address());
        }

        public Buffer flexBasis(Consumer<YGValue> consumer) {
            consumer.accept(this.flexBasis());
            return this;
        }

        @NativeType(value="YGValue[9]")
        public YGValue.Buffer margin() {
            return YGStyle.nmargin(this.address());
        }

        public YGValue margin(int index) {
            return YGStyle.nmargin(this.address(), index);
        }

        @NativeType(value="YGValue[9]")
        public YGValue.Buffer positions() {
            return YGStyle.npositions(this.address());
        }

        public YGValue positions(int index) {
            return YGStyle.npositions(this.address(), index);
        }

        @NativeType(value="YGValue[9]")
        public YGValue.Buffer padding() {
            return YGStyle.npadding(this.address());
        }

        public YGValue padding(int index) {
            return YGStyle.npadding(this.address(), index);
        }

        @NativeType(value="YGValue[9]")
        public YGValue.Buffer border() {
            return YGStyle.nborder(this.address());
        }

        public YGValue border(int index) {
            return YGStyle.nborder(this.address(), index);
        }

        @NativeType(value="YGValue[2]")
        public YGValue.Buffer dimensions() {
            return YGStyle.ndimensions(this.address());
        }

        public YGValue dimensions(int index) {
            return YGStyle.ndimensions(this.address(), index);
        }

        @NativeType(value="YGValue[2]")
        public YGValue.Buffer minDimensions() {
            return YGStyle.nminDimensions(this.address());
        }

        public YGValue minDimensions(int index) {
            return YGStyle.nminDimensions(this.address(), index);
        }

        @NativeType(value="YGValue[2]")
        public YGValue.Buffer maxDimensions() {
            return YGStyle.nmaxDimensions(this.address());
        }

        public YGValue maxDimensions(int index) {
            return YGStyle.nmaxDimensions(this.address(), index);
        }

        public YGFloatOptional aspectRatio() {
            return YGStyle.naspectRatio(this.address());
        }
    }
}

