/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.yoga.YGBaselineFunc;
import org.lwjgl.util.yoga.YGBaselineFuncI;
import org.lwjgl.util.yoga.YGDirtiedFunc;
import org.lwjgl.util.yoga.YGDirtiedFuncI;
import org.lwjgl.util.yoga.YGLayout;
import org.lwjgl.util.yoga.YGMeasureFunc;
import org.lwjgl.util.yoga.YGMeasureFuncI;
import org.lwjgl.util.yoga.YGPrintFunc;
import org.lwjgl.util.yoga.YGPrintFuncI;
import org.lwjgl.util.yoga.YGStyle;
import org.lwjgl.util.yoga.YGValue;

public class YGNode
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CONTEXT;
    public static final int PRINT;
    public static final int HASNEWLAYOUT;
    public static final int NODETYPE;
    public static final int MEASURE;
    public static final int BASELINE;
    public static final int DIRTIED;
    public static final int STYLE;
    public static final int LAYOUT;
    public static final int LINEINDEX;
    public static final int OWNER;
    public static final int CHILDREN;
    public static final int NEXTCHILD;
    public static final int CONFIG;
    public static final int ISDIRTY;
    public static final int RESOLVEDDIMENSIONS;

    YGNode(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public YGNode(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), YGNode.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long context() {
        return YGNode.ncontext(this.address());
    }

    @Nullable
    public YGPrintFunc print() {
        return YGNode.nprint(this.address());
    }

    @NativeType(value="bool")
    public boolean hasNewLayout() {
        return YGNode.nhasNewLayout(this.address());
    }

    @NativeType(value="YGNodeType")
    public int nodeType() {
        return YGNode.nnodeType(this.address());
    }

    @Nullable
    public YGMeasureFunc measure() {
        return YGNode.nmeasure(this.address());
    }

    @Nullable
    public YGBaselineFunc baseline() {
        return YGNode.nbaseline(this.address());
    }

    @Nullable
    public YGDirtiedFunc dirtied() {
        return YGNode.ndirtied(this.address());
    }

    public YGStyle style() {
        return YGNode.nstyle(this.address());
    }

    public YGLayout layout() {
        return YGNode.nlayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int lineIndex() {
        return YGNode.nlineIndex(this.address());
    }

    @NativeType(value="YGNodeRef")
    public long owner() {
        return YGNode.nowner(this.address());
    }

    @NativeType(value="YGNodeListRef")
    public long children() {
        return YGNode.nchildren(this.address());
    }

    @Nullable
    @NativeType(value="YGNode *")
    public YGNode nextChild() {
        return YGNode.nnextChild(this.address());
    }

    @NativeType(value="YGConfigRef")
    public long config() {
        return YGNode.nconfig(this.address());
    }

    @NativeType(value="bool")
    public boolean isDirty() {
        return YGNode.nisDirty(this.address());
    }

    @NativeType(value="YGValue *[2]")
    public PointerBuffer resolvedDimensions() {
        return YGNode.nresolvedDimensions(this.address());
    }

    @NativeType(value="YGValue *")
    public YGValue resolvedDimensions(int index) {
        return YGNode.nresolvedDimensions(this.address(), index);
    }

    public YGNode context(@NativeType(value="void *") long value) {
        YGNode.ncontext(this.address(), value);
        return this;
    }

    public YGNode print(@Nullable @NativeType(value="YGPrintFunc") YGPrintFuncI value) {
        YGNode.nprint(this.address(), value);
        return this;
    }

    public YGNode hasNewLayout(@NativeType(value="bool") boolean value) {
        YGNode.nhasNewLayout(this.address(), value);
        return this;
    }

    public YGNode nodeType(@NativeType(value="YGNodeType") int value) {
        YGNode.nnodeType(this.address(), value);
        return this;
    }

    public YGNode measure(@Nullable @NativeType(value="YGMeasureFunc") YGMeasureFuncI value) {
        YGNode.nmeasure(this.address(), value);
        return this;
    }

    public YGNode baseline(@Nullable @NativeType(value="YGBaselineFunc") YGBaselineFuncI value) {
        YGNode.nbaseline(this.address(), value);
        return this;
    }

    public YGNode dirtied(@Nullable @NativeType(value="YGDirtiedFunc") YGDirtiedFuncI value) {
        YGNode.ndirtied(this.address(), value);
        return this;
    }

    public YGNode style(YGStyle value) {
        YGNode.nstyle(this.address(), value);
        return this;
    }

    public YGNode layout(YGLayout value) {
        YGNode.nlayout(this.address(), value);
        return this;
    }

    public YGNode lineIndex(@NativeType(value="uint32_t") int value) {
        YGNode.nlineIndex(this.address(), value);
        return this;
    }

    public YGNode owner(@NativeType(value="YGNodeRef") long value) {
        YGNode.nowner(this.address(), value);
        return this;
    }

    public YGNode children(@NativeType(value="YGNodeListRef") long value) {
        YGNode.nchildren(this.address(), value);
        return this;
    }

    public YGNode nextChild(@Nullable @NativeType(value="YGNode *") YGNode value) {
        YGNode.nnextChild(this.address(), value);
        return this;
    }

    public YGNode config(@NativeType(value="YGConfigRef") long value) {
        YGNode.nconfig(this.address(), value);
        return this;
    }

    public YGNode isDirty(@NativeType(value="bool") boolean value) {
        YGNode.nisDirty(this.address(), value);
        return this;
    }

    public YGNode resolvedDimensions(@NativeType(value="YGValue *[2]") PointerBuffer value) {
        YGNode.nresolvedDimensions(this.address(), value);
        return this;
    }

    public YGNode resolvedDimensions(int index, @NativeType(value="YGValue *") YGValue value) {
        YGNode.nresolvedDimensions(this.address(), index, value);
        return this;
    }

    public YGNode set(long context, @Nullable YGPrintFuncI print, boolean hasNewLayout, int nodeType, @Nullable YGMeasureFuncI measure, @Nullable YGBaselineFuncI baseline, @Nullable YGDirtiedFuncI dirtied, YGStyle style, YGLayout layout, int lineIndex, long owner, long children, @Nullable YGNode nextChild, long config, boolean isDirty, PointerBuffer resolvedDimensions) {
        this.context(context);
        this.print(print);
        this.hasNewLayout(hasNewLayout);
        this.nodeType(nodeType);
        this.measure(measure);
        this.baseline(baseline);
        this.dirtied(dirtied);
        this.style(style);
        this.layout(layout);
        this.lineIndex(lineIndex);
        this.owner(owner);
        this.children(children);
        this.nextChild(nextChild);
        this.config(config);
        this.isDirty(isDirty);
        this.resolvedDimensions(resolvedDimensions);
        return this;
    }

    public YGNode set(YGNode src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static YGNode malloc() {
        return YGNode.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static YGNode calloc() {
        return YGNode.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static YGNode create() {
        return new YGNode(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static YGNode create(long address) {
        return new YGNode(address, null);
    }

    @Nullable
    public static YGNode createSafe(long address) {
        return address == 0L ? null : YGNode.create(address);
    }

    public static Buffer malloc(int capacity) {
        return YGNode.create(YGNode.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return YGNode.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(YGNode.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : YGNode.create(address, capacity);
    }

    public static YGNode mallocStack() {
        return YGNode.mallocStack(MemoryStack.stackGet());
    }

    public static YGNode callocStack() {
        return YGNode.callocStack(MemoryStack.stackGet());
    }

    public static YGNode mallocStack(MemoryStack stack) {
        return YGNode.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static YGNode callocStack(MemoryStack stack) {
        return YGNode.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return YGNode.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return YGNode.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return YGNode.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return YGNode.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ncontext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CONTEXT);
    }

    @Nullable
    public static YGPrintFunc nprint(long struct) {
        return YGPrintFunc.createSafe(MemoryUtil.memGetAddress(struct + (long)PRINT));
    }

    public static boolean nhasNewLayout(long struct) {
        return MemoryUtil.memGetByte(struct + (long)HASNEWLAYOUT) != 0;
    }

    public static int nnodeType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NODETYPE);
    }

    @Nullable
    public static YGMeasureFunc nmeasure(long struct) {
        return YGMeasureFunc.createSafe(MemoryUtil.memGetAddress(struct + (long)MEASURE));
    }

    @Nullable
    public static YGBaselineFunc nbaseline(long struct) {
        return YGBaselineFunc.createSafe(MemoryUtil.memGetAddress(struct + (long)BASELINE));
    }

    @Nullable
    public static YGDirtiedFunc ndirtied(long struct) {
        return YGDirtiedFunc.createSafe(MemoryUtil.memGetAddress(struct + (long)DIRTIED));
    }

    public static YGStyle nstyle(long struct) {
        return YGStyle.create(struct + (long)STYLE);
    }

    public static YGLayout nlayout(long struct) {
        return YGLayout.create(struct + (long)LAYOUT);
    }

    public static int nlineIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LINEINDEX);
    }

    public static long nowner(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)OWNER);
    }

    public static long nchildren(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CHILDREN);
    }

    @Nullable
    public static YGNode nnextChild(long struct) {
        return YGNode.createSafe(MemoryUtil.memGetAddress(struct + (long)NEXTCHILD));
    }

    public static long nconfig(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CONFIG);
    }

    public static boolean nisDirty(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ISDIRTY) != 0;
    }

    public static PointerBuffer nresolvedDimensions(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)RESOLVEDDIMENSIONS, 2);
    }

    public static YGValue nresolvedDimensions(long struct, int index) {
        return YGValue.create(MemoryUtil.memGetAddress(struct + (long)RESOLVEDDIMENSIONS + Checks.check(index, 2) * (long)POINTER_SIZE));
    }

    public static void ncontext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CONTEXT, value);
    }

    public static void nprint(long struct, @Nullable YGPrintFuncI value) {
        MemoryUtil.memPutAddress(struct + (long)PRINT, MemoryUtil.memAddressSafe(value));
    }

    public static void nhasNewLayout(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)HASNEWLAYOUT, value ? (byte)1 : 0);
    }

    public static void nnodeType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NODETYPE, value);
    }

    public static void nmeasure(long struct, @Nullable YGMeasureFuncI value) {
        MemoryUtil.memPutAddress(struct + (long)MEASURE, MemoryUtil.memAddressSafe(value));
    }

    public static void nbaseline(long struct, @Nullable YGBaselineFuncI value) {
        MemoryUtil.memPutAddress(struct + (long)BASELINE, MemoryUtil.memAddressSafe(value));
    }

    public static void ndirtied(long struct, @Nullable YGDirtiedFuncI value) {
        MemoryUtil.memPutAddress(struct + (long)DIRTIED, MemoryUtil.memAddressSafe(value));
    }

    public static void nstyle(long struct, YGStyle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)STYLE, YGStyle.SIZEOF);
    }

    public static void nlayout(long struct, YGLayout value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LAYOUT, YGLayout.SIZEOF);
    }

    public static void nlineIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LINEINDEX, value);
    }

    public static void nowner(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)OWNER, value);
    }

    public static void nchildren(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CHILDREN, value);
    }

    public static void nnextChild(long struct, @Nullable YGNode value) {
        MemoryUtil.memPutAddress(struct + (long)NEXTCHILD, MemoryUtil.memAddressSafe(value));
    }

    public static void nconfig(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CONFIG, value);
    }

    public static void nisDirty(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)ISDIRTY, value ? (byte)1 : 0);
    }

    public static void nresolvedDimensions(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESOLVEDDIMENSIONS, value.remaining() * POINTER_SIZE);
    }

    public static void nresolvedDimensions(long struct, int index, YGValue value) {
        MemoryUtil.memPutAddress(struct + (long)RESOLVEDDIMENSIONS + Checks.check(index, 2) * (long)POINTER_SIZE, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)RESOLVEDDIMENSIONS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            YGNode.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = YGNode.__struct(YGNode.__member(POINTER_SIZE), YGNode.__member(POINTER_SIZE), YGNode.__member(1), YGNode.__member(4), YGNode.__member(POINTER_SIZE), YGNode.__member(POINTER_SIZE), YGNode.__member(POINTER_SIZE), YGNode.__member(YGStyle.SIZEOF, YGStyle.ALIGNOF), YGNode.__member(YGLayout.SIZEOF, YGLayout.ALIGNOF), YGNode.__member(4), YGNode.__member(POINTER_SIZE), YGNode.__member(POINTER_SIZE), YGNode.__member(POINTER_SIZE), YGNode.__member(POINTER_SIZE), YGNode.__member(1), YGNode.__array(POINTER_SIZE, 2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CONTEXT = layout.offsetof(0);
        PRINT = layout.offsetof(1);
        HASNEWLAYOUT = layout.offsetof(2);
        NODETYPE = layout.offsetof(3);
        MEASURE = layout.offsetof(4);
        BASELINE = layout.offsetof(5);
        DIRTIED = layout.offsetof(6);
        STYLE = layout.offsetof(7);
        LAYOUT = layout.offsetof(8);
        LINEINDEX = layout.offsetof(9);
        OWNER = layout.offsetof(10);
        CHILDREN = layout.offsetof(11);
        NEXTCHILD = layout.offsetof(12);
        CONFIG = layout.offsetof(13);
        ISDIRTY = layout.offsetof(14);
        RESOLVEDDIMENSIONS = layout.offsetof(15);
    }

    public static class Buffer
    extends StructBuffer<YGNode, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected YGNode newInstance(long address) {
            return new YGNode(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="void *")
        public long context() {
            return YGNode.ncontext(this.address());
        }

        @Nullable
        public YGPrintFunc print() {
            return YGNode.nprint(this.address());
        }

        @NativeType(value="bool")
        public boolean hasNewLayout() {
            return YGNode.nhasNewLayout(this.address());
        }

        @NativeType(value="YGNodeType")
        public int nodeType() {
            return YGNode.nnodeType(this.address());
        }

        @Nullable
        public YGMeasureFunc measure() {
            return YGNode.nmeasure(this.address());
        }

        @Nullable
        public YGBaselineFunc baseline() {
            return YGNode.nbaseline(this.address());
        }

        @Nullable
        public YGDirtiedFunc dirtied() {
            return YGNode.ndirtied(this.address());
        }

        public YGStyle style() {
            return YGNode.nstyle(this.address());
        }

        public YGLayout layout() {
            return YGNode.nlayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int lineIndex() {
            return YGNode.nlineIndex(this.address());
        }

        @NativeType(value="YGNodeRef")
        public long owner() {
            return YGNode.nowner(this.address());
        }

        @NativeType(value="YGNodeListRef")
        public long children() {
            return YGNode.nchildren(this.address());
        }

        @Nullable
        @NativeType(value="YGNode *")
        public YGNode nextChild() {
            return YGNode.nnextChild(this.address());
        }

        @NativeType(value="YGConfigRef")
        public long config() {
            return YGNode.nconfig(this.address());
        }

        @NativeType(value="bool")
        public boolean isDirty() {
            return YGNode.nisDirty(this.address());
        }

        @NativeType(value="YGValue *[2]")
        public PointerBuffer resolvedDimensions() {
            return YGNode.nresolvedDimensions(this.address());
        }

        @NativeType(value="YGValue *")
        public YGValue resolvedDimensions(int index) {
            return YGNode.nresolvedDimensions(this.address(), index);
        }

        public Buffer context(@NativeType(value="void *") long value) {
            YGNode.ncontext(this.address(), value);
            return this;
        }

        public Buffer print(@Nullable @NativeType(value="YGPrintFunc") YGPrintFuncI value) {
            YGNode.nprint(this.address(), value);
            return this;
        }

        public Buffer hasNewLayout(@NativeType(value="bool") boolean value) {
            YGNode.nhasNewLayout(this.address(), value);
            return this;
        }

        public Buffer nodeType(@NativeType(value="YGNodeType") int value) {
            YGNode.nnodeType(this.address(), value);
            return this;
        }

        public Buffer measure(@Nullable @NativeType(value="YGMeasureFunc") YGMeasureFuncI value) {
            YGNode.nmeasure(this.address(), value);
            return this;
        }

        public Buffer baseline(@Nullable @NativeType(value="YGBaselineFunc") YGBaselineFuncI value) {
            YGNode.nbaseline(this.address(), value);
            return this;
        }

        public Buffer dirtied(@Nullable @NativeType(value="YGDirtiedFunc") YGDirtiedFuncI value) {
            YGNode.ndirtied(this.address(), value);
            return this;
        }

        public Buffer style(YGStyle value) {
            YGNode.nstyle(this.address(), value);
            return this;
        }

        public Buffer layout(YGLayout value) {
            YGNode.nlayout(this.address(), value);
            return this;
        }

        public Buffer lineIndex(@NativeType(value="uint32_t") int value) {
            YGNode.nlineIndex(this.address(), value);
            return this;
        }

        public Buffer owner(@NativeType(value="YGNodeRef") long value) {
            YGNode.nowner(this.address(), value);
            return this;
        }

        public Buffer children(@NativeType(value="YGNodeListRef") long value) {
            YGNode.nchildren(this.address(), value);
            return this;
        }

        public Buffer nextChild(@Nullable @NativeType(value="YGNode *") YGNode value) {
            YGNode.nnextChild(this.address(), value);
            return this;
        }

        public Buffer config(@NativeType(value="YGConfigRef") long value) {
            YGNode.nconfig(this.address(), value);
            return this;
        }

        public Buffer isDirty(@NativeType(value="bool") boolean value) {
            YGNode.nisDirty(this.address(), value);
            return this;
        }

        public Buffer resolvedDimensions(@NativeType(value="YGValue *[2]") PointerBuffer value) {
            YGNode.nresolvedDimensions(this.address(), value);
            return this;
        }

        public Buffer resolvedDimensions(int index, @NativeType(value="YGValue *") YGValue value) {
            YGNode.nresolvedDimensions(this.address(), index, value);
            return this;
        }
    }
}

