/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class YGCachedMeasurement
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int AVAILABLEWIDTH;
    public static final int AVAILABLEHEIGHT;
    public static final int WIDTHMEASUREMODE;
    public static final int HEIGHTMEASUREMODE;
    public static final int COMPUTEDWIDTH;
    public static final int COMPUTEDHEIGHT;

    YGCachedMeasurement(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public YGCachedMeasurement(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), YGCachedMeasurement.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float availableWidth() {
        return YGCachedMeasurement.navailableWidth(this.address());
    }

    public float availableHeight() {
        return YGCachedMeasurement.navailableHeight(this.address());
    }

    @NativeType(value="YGMeasureMode")
    public int widthMeasureMode() {
        return YGCachedMeasurement.nwidthMeasureMode(this.address());
    }

    @NativeType(value="YGMeasureMode")
    public int heightMeasureMode() {
        return YGCachedMeasurement.nheightMeasureMode(this.address());
    }

    public float computedWidth() {
        return YGCachedMeasurement.ncomputedWidth(this.address());
    }

    public float computedHeight() {
        return YGCachedMeasurement.ncomputedHeight(this.address());
    }

    public static YGCachedMeasurement create(long address) {
        return new YGCachedMeasurement(address, null);
    }

    @Nullable
    public static YGCachedMeasurement createSafe(long address) {
        return address == 0L ? null : YGCachedMeasurement.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : YGCachedMeasurement.create(address, capacity);
    }

    public static float navailableWidth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)AVAILABLEWIDTH);
    }

    public static float navailableHeight(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)AVAILABLEHEIGHT);
    }

    public static int nwidthMeasureMode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTHMEASUREMODE);
    }

    public static int nheightMeasureMode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHTMEASUREMODE);
    }

    public static float ncomputedWidth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)COMPUTEDWIDTH);
    }

    public static float ncomputedHeight(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)COMPUTEDHEIGHT);
    }

    static {
        Struct.Layout layout = YGCachedMeasurement.__struct(YGCachedMeasurement.__member(4), YGCachedMeasurement.__member(4), YGCachedMeasurement.__member(4), YGCachedMeasurement.__member(4), YGCachedMeasurement.__member(4), YGCachedMeasurement.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        AVAILABLEWIDTH = layout.offsetof(0);
        AVAILABLEHEIGHT = layout.offsetof(1);
        WIDTHMEASUREMODE = layout.offsetof(2);
        HEIGHTMEASUREMODE = layout.offsetof(3);
        COMPUTEDWIDTH = layout.offsetof(4);
        COMPUTEDHEIGHT = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<YGCachedMeasurement, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected YGCachedMeasurement newInstance(long address) {
            return new YGCachedMeasurement(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float availableWidth() {
            return YGCachedMeasurement.navailableWidth(this.address());
        }

        public float availableHeight() {
            return YGCachedMeasurement.navailableHeight(this.address());
        }

        @NativeType(value="YGMeasureMode")
        public int widthMeasureMode() {
            return YGCachedMeasurement.nwidthMeasureMode(this.address());
        }

        @NativeType(value="YGMeasureMode")
        public int heightMeasureMode() {
            return YGCachedMeasurement.nheightMeasureMode(this.address());
        }

        public float computedWidth() {
            return YGCachedMeasurement.ncomputedWidth(this.address());
        }

        public float computedHeight() {
            return YGCachedMeasurement.ncomputedHeight(this.address());
        }
    }
}

