/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaStatInfo;

public class VmaStats
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MEMORYTYPE;
    public static final int MEMORYHEAP;
    public static final int TOTAL;

    VmaStats(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VmaStats(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VmaStats.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VmaStatInfo[32]")
    public VmaStatInfo.Buffer memoryType() {
        return VmaStats.nmemoryType(this.address());
    }

    public VmaStatInfo memoryType(int index) {
        return VmaStats.nmemoryType(this.address(), index);
    }

    @NativeType(value="VmaStatInfo[16]")
    public VmaStatInfo.Buffer memoryHeap() {
        return VmaStats.nmemoryHeap(this.address());
    }

    public VmaStatInfo memoryHeap(int index) {
        return VmaStats.nmemoryHeap(this.address(), index);
    }

    public VmaStatInfo total() {
        return VmaStats.ntotal(this.address());
    }

    public static VmaStats malloc() {
        return VmaStats.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaStats calloc() {
        return VmaStats.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaStats create() {
        return new VmaStats(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VmaStats create(long address) {
        return new VmaStats(address, null);
    }

    @Nullable
    public static VmaStats createSafe(long address) {
        return address == 0L ? null : VmaStats.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VmaStats.create(VmaStats.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaStats.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VmaStats.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaStats.create(address, capacity);
    }

    public static VmaStats mallocStack() {
        return VmaStats.mallocStack(MemoryStack.stackGet());
    }

    public static VmaStats callocStack() {
        return VmaStats.callocStack(MemoryStack.stackGet());
    }

    public static VmaStats mallocStack(MemoryStack stack) {
        return VmaStats.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaStats callocStack(MemoryStack stack) {
        return VmaStats.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VmaStats.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VmaStats.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaStats.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaStats.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VmaStatInfo.Buffer nmemoryType(long struct) {
        return VmaStatInfo.create(struct + (long)MEMORYTYPE, 32);
    }

    public static VmaStatInfo nmemoryType(long struct, int index) {
        return VmaStatInfo.create(struct + (long)MEMORYTYPE + Checks.check(index, 32) * (long)VmaStatInfo.SIZEOF);
    }

    public static VmaStatInfo.Buffer nmemoryHeap(long struct) {
        return VmaStatInfo.create(struct + (long)MEMORYHEAP, 16);
    }

    public static VmaStatInfo nmemoryHeap(long struct, int index) {
        return VmaStatInfo.create(struct + (long)MEMORYHEAP + Checks.check(index, 16) * (long)VmaStatInfo.SIZEOF);
    }

    public static VmaStatInfo ntotal(long struct) {
        return VmaStatInfo.create(struct + (long)TOTAL);
    }

    static {
        Struct.Layout layout = VmaStats.__struct(VmaStats.__array(VmaStatInfo.SIZEOF, VmaStatInfo.ALIGNOF, 32), VmaStats.__array(VmaStatInfo.SIZEOF, VmaStatInfo.ALIGNOF, 16), VmaStats.__member(VmaStatInfo.SIZEOF, VmaStatInfo.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MEMORYTYPE = layout.offsetof(0);
        MEMORYHEAP = layout.offsetof(1);
        TOTAL = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaStats, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VmaStats newInstance(long address) {
            return new VmaStats(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VmaStatInfo[32]")
        public VmaStatInfo.Buffer memoryType() {
            return VmaStats.nmemoryType(this.address());
        }

        public VmaStatInfo memoryType(int index) {
            return VmaStats.nmemoryType(this.address(), index);
        }

        @NativeType(value="VmaStatInfo[16]")
        public VmaStatInfo.Buffer memoryHeap() {
            return VmaStats.nmemoryHeap(this.address());
        }

        public VmaStatInfo memoryHeap(int index) {
            return VmaStats.nmemoryHeap(this.address(), index);
        }

        public VmaStatInfo total() {
            return VmaStats.ntotal(this.address());
        }
    }
}

