/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaPoolStats
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int UNUSEDSIZE;
    public static final int ALLOCATIONCOUNT;
    public static final int UNUSEDRANGECOUNT;
    public static final int UNUSEDRANGESIZEMAX;

    VmaPoolStats(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VmaPoolStats(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VmaPoolStats.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VmaPoolStats.nsize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long unusedSize() {
        return VmaPoolStats.nunusedSize(this.address());
    }

    @NativeType(value="size_t")
    public long allocationCount() {
        return VmaPoolStats.nallocationCount(this.address());
    }

    @NativeType(value="size_t")
    public long unusedRangeCount() {
        return VmaPoolStats.nunusedRangeCount(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long unusedRangeSizeMax() {
        return VmaPoolStats.nunusedRangeSizeMax(this.address());
    }

    public static VmaPoolStats malloc() {
        return VmaPoolStats.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaPoolStats calloc() {
        return VmaPoolStats.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaPoolStats create() {
        return new VmaPoolStats(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VmaPoolStats create(long address) {
        return new VmaPoolStats(address, null);
    }

    @Nullable
    public static VmaPoolStats createSafe(long address) {
        return address == 0L ? null : VmaPoolStats.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VmaPoolStats.create(VmaPoolStats.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaPoolStats.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VmaPoolStats.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaPoolStats.create(address, capacity);
    }

    public static VmaPoolStats mallocStack() {
        return VmaPoolStats.mallocStack(MemoryStack.stackGet());
    }

    public static VmaPoolStats callocStack() {
        return VmaPoolStats.callocStack(MemoryStack.stackGet());
    }

    public static VmaPoolStats mallocStack(MemoryStack stack) {
        return VmaPoolStats.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaPoolStats callocStack(MemoryStack stack) {
        return VmaPoolStats.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VmaPoolStats.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VmaPoolStats.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaPoolStats.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaPoolStats.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static long nunusedSize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)UNUSEDSIZE);
    }

    public static long nallocationCount(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ALLOCATIONCOUNT);
    }

    public static long nunusedRangeCount(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)UNUSEDRANGECOUNT);
    }

    public static long nunusedRangeSizeMax(long struct) {
        return MemoryUtil.memGetLong(struct + (long)UNUSEDRANGESIZEMAX);
    }

    static {
        Struct.Layout layout = VmaPoolStats.__struct(VmaPoolStats.__member(8), VmaPoolStats.__member(8), VmaPoolStats.__member(POINTER_SIZE), VmaPoolStats.__member(POINTER_SIZE), VmaPoolStats.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        UNUSEDSIZE = layout.offsetof(1);
        ALLOCATIONCOUNT = layout.offsetof(2);
        UNUSEDRANGECOUNT = layout.offsetof(3);
        UNUSEDRANGESIZEMAX = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VmaPoolStats, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VmaPoolStats newInstance(long address) {
            return new VmaPoolStats(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VmaPoolStats.nsize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long unusedSize() {
            return VmaPoolStats.nunusedSize(this.address());
        }

        @NativeType(value="size_t")
        public long allocationCount() {
            return VmaPoolStats.nallocationCount(this.address());
        }

        @NativeType(value="size_t")
        public long unusedRangeCount() {
            return VmaPoolStats.nunusedRangeCount(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long unusedRangeSizeMax() {
            return VmaPoolStats.nunusedRangeSizeMax(this.address());
        }
    }
}

