/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaDefragmentationStats
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BYTESMOVED;
    public static final int BYTESFREED;
    public static final int ALLOCATIONSMOVED;
    public static final int DEVICEMEMORYBLOCKSFREED;

    VmaDefragmentationStats(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VmaDefragmentationStats(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VmaDefragmentationStats.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long bytesMoved() {
        return VmaDefragmentationStats.nbytesMoved(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long bytesFreed() {
        return VmaDefragmentationStats.nbytesFreed(this.address());
    }

    @NativeType(value="uint32_t")
    public int allocationsMoved() {
        return VmaDefragmentationStats.nallocationsMoved(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceMemoryBlocksFreed() {
        return VmaDefragmentationStats.ndeviceMemoryBlocksFreed(this.address());
    }

    public static VmaDefragmentationStats malloc() {
        return VmaDefragmentationStats.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaDefragmentationStats calloc() {
        return VmaDefragmentationStats.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaDefragmentationStats create() {
        return new VmaDefragmentationStats(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VmaDefragmentationStats create(long address) {
        return new VmaDefragmentationStats(address, null);
    }

    @Nullable
    public static VmaDefragmentationStats createSafe(long address) {
        return address == 0L ? null : VmaDefragmentationStats.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VmaDefragmentationStats.create(VmaDefragmentationStats.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaDefragmentationStats.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VmaDefragmentationStats.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaDefragmentationStats.create(address, capacity);
    }

    public static VmaDefragmentationStats mallocStack() {
        return VmaDefragmentationStats.mallocStack(MemoryStack.stackGet());
    }

    public static VmaDefragmentationStats callocStack() {
        return VmaDefragmentationStats.callocStack(MemoryStack.stackGet());
    }

    public static VmaDefragmentationStats mallocStack(MemoryStack stack) {
        return VmaDefragmentationStats.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaDefragmentationStats callocStack(MemoryStack stack) {
        return VmaDefragmentationStats.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VmaDefragmentationStats.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VmaDefragmentationStats.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationStats.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationStats.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbytesMoved(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BYTESMOVED);
    }

    public static long nbytesFreed(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BYTESFREED);
    }

    public static int nallocationsMoved(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ALLOCATIONSMOVED);
    }

    public static int ndeviceMemoryBlocksFreed(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICEMEMORYBLOCKSFREED);
    }

    static {
        Struct.Layout layout = VmaDefragmentationStats.__struct(VmaDefragmentationStats.__member(8), VmaDefragmentationStats.__member(8), VmaDefragmentationStats.__member(4), VmaDefragmentationStats.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BYTESMOVED = layout.offsetof(0);
        BYTESFREED = layout.offsetof(1);
        ALLOCATIONSMOVED = layout.offsetof(2);
        DEVICEMEMORYBLOCKSFREED = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VmaDefragmentationStats, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VmaDefragmentationStats newInstance(long address) {
            return new VmaDefragmentationStats(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VkDeviceSize")
        public long bytesMoved() {
            return VmaDefragmentationStats.nbytesMoved(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long bytesFreed() {
            return VmaDefragmentationStats.nbytesFreed(this.address());
        }

        @NativeType(value="uint32_t")
        public int allocationsMoved() {
            return VmaDefragmentationStats.nallocationsMoved(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceMemoryBlocksFreed() {
            return VmaDefragmentationStats.ndeviceMemoryBlocksFreed(this.address());
        }
    }
}

